/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mapping.base;

import cool.scx.jdbc.mapping.Schema;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.mapping.base.BaseTable;
import java.util.HashMap;
import java.util.Map;

public class BaseSchema
implements Schema {
    private final Map<String, BaseTable> tableMap = new HashMap<String, BaseTable>();
    private String catalog;
    private String name;

    public BaseSchema() {
    }

    public BaseSchema(Schema oldSchema) {
        this.setCatalog(oldSchema.catalog());
        this.setName(oldSchema.name());
        for (Table table : oldSchema.tables()) {
            this.addTable(table);
        }
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String name() {
        return this.name;
    }

    public BaseTable[] tables() {
        return (BaseTable[])this.tableMap.values().toArray(BaseTable[]::new);
    }

    @Override
    public BaseTable getTable(String name) {
        return this.tableMap.get(name);
    }

    public BaseSchema setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public BaseSchema setName(String name) {
        this.name = name;
        return this;
    }

    public BaseSchema addTable(Table oldTable) {
        BaseTable table = new BaseTable(oldTable);
        this.tableMap.put(table.name(), table);
        return this;
    }

    public BaseSchema removeTable(String name) {
        this.tableMap.remove(name);
        return this;
    }

    public BaseSchema clearTables() {
        this.tableMap.clear();
        return this;
    }
}

