/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

record MapHandler(Supplier<Map<String, Object>> mapSupplier) implements ResultHandler<Map<String, Object>>
{
    static final MapHandler INSTANCE = new MapHandler();

    public MapHandler() {
        this(HashMap::new);
    }

    @Override
    public Map<String, Object> apply(ResultSet rs, Dialect dialect) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int count = rsm.getColumnCount();
        if (rs.next()) {
            Map<String, Object> map = this.mapSupplier.get();
            for (int i = 1; i <= count; ++i) {
                map.put(rsm.getColumnLabel(i), rs.getObject(i));
            }
            return map;
        }
        return null;
    }
}

