/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.spy.wrapper;

import cool.scx.common.util.ArrayUtils;
import cool.scx.jdbc.spy.SpyEventListener;
import cool.scx.jdbc.spy.SpyWrapper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementWrapper<T extends Statement>
extends SpyWrapper<T>
implements Statement {
    protected StatementWrapper(T delegate, SpyEventListener eventListener) {
        super(delegate, eventListener);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            ResultSet resultSet = ((Statement)this.delegate).getResultSet();
            return resultSet;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterGetResultSet((Statement)this.delegate, System.nanoTime() - start, e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecuteQuery((Statement)this.delegate, sql);
            ResultSet resultSet = ((Statement)this.delegate).executeQuery(sql);
            return resultSet;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteQuery((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        SQLException e = null;
        long start = System.nanoTime();
        int[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch((Statement)this.delegate);
            nArray = updateCounts = ((Statement)this.delegate).executeBatch();
        }
        catch (SQLException s) {
            try {
                e = s;
                throw e;
            }
            catch (Throwable throwable) {
                this.eventListener.onAfterExecuteBatch((Statement)this.delegate, System.nanoTime() - start, updateCounts == null ? null : ArrayUtils.toLongArray((int[])updateCounts), e);
                throw throwable;
            }
        }
        this.eventListener.onAfterExecuteBatch((Statement)this.delegate, System.nanoTime() - start, updateCounts == null ? null : ArrayUtils.toLongArray((int[])updateCounts), e);
        return nArray;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long[] updateCounts = null;
        try {
            this.eventListener.onBeforeExecuteBatch((Statement)this.delegate);
            long[] lArray = updateCounts = ((Statement)this.delegate).executeLargeBatch();
            return lArray;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteBatch((Statement)this.delegate, System.nanoTime() - start, updateCounts, e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute((Statement)this.delegate, sql);
            boolean bl = ((Statement)this.delegate).execute(sql);
            return bl;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute((Statement)this.delegate, sql);
            boolean bl = ((Statement)this.delegate).execute(sql, autoGeneratedKeys);
            return bl;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute((Statement)this.delegate, sql);
            boolean bl = ((Statement)this.delegate).execute(sql, columnIndexes);
            return bl;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeExecute((Statement)this.delegate, sql);
            boolean bl = ((Statement)this.delegate).execute(sql, columnNames);
            return bl;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecute((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            int n = rowCount = ((Statement)this.delegate).executeUpdate(sql);
            return n;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            int n = rowCount = ((Statement)this.delegate).executeUpdate(sql, autoGeneratedKeys);
            return n;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            int n = rowCount = ((Statement)this.delegate).executeUpdate(sql, columnIndexes);
            return n;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        int rowCount = 0;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            int n = rowCount = ((Statement)this.delegate).executeUpdate(sql, columnNames);
            return n;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            long l = rowCount = ((Statement)this.delegate).executeLargeUpdate(sql);
            return l;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            long l = rowCount = ((Statement)this.delegate).executeLargeUpdate(sql, autoGeneratedKeys);
            return l;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            long l = rowCount = ((Statement)this.delegate).executeLargeUpdate(sql, columnIndexes);
            return l;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        long rowCount = 0L;
        try {
            this.eventListener.onBeforeExecuteUpdate((Statement)this.delegate, sql);
            long l = rowCount = ((Statement)this.delegate).executeLargeUpdate(sql, columnNames);
            return l;
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterExecuteUpdate((Statement)this.delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SQLException e = null;
        long start = System.nanoTime();
        try {
            this.eventListener.onBeforeAddBatch((Statement)this.delegate, sql);
            ((Statement)this.delegate).addBatch(sql);
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterAddBatch((Statement)this.delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            ((Statement)this.delegate).close();
        }
        catch (SQLException s) {
            e = s;
            throw e;
        }
        finally {
            this.eventListener.onAfterStatementClose((Statement)this.delegate, e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return ((Statement)this.delegate).getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        ((Statement)this.delegate).setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return ((Statement)this.delegate).getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        ((Statement)this.delegate).setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        ((Statement)this.delegate).setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return ((Statement)this.delegate).getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        ((Statement)this.delegate).setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        ((Statement)this.delegate).cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return ((Statement)this.delegate).getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        ((Statement)this.delegate).clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        ((Statement)this.delegate).setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return ((Statement)this.delegate).getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return ((Statement)this.delegate).getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return ((Statement)this.delegate).getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        ((Statement)this.delegate).setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return ((Statement)this.delegate).getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        ((Statement)this.delegate).setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return ((Statement)this.delegate).getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return ((Statement)this.delegate).getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        ((Statement)this.delegate).clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((Statement)this.delegate).getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return ((Statement)this.delegate).getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return ((Statement)this.delegate).getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return ((Statement)this.delegate).getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return ((Statement)this.delegate).isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return ((Statement)this.delegate).isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        ((Statement)this.delegate).setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        ((Statement)this.delegate).closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return ((Statement)this.delegate).isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return ((Statement)this.delegate).getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return ((Statement)this.delegate).getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        ((Statement)this.delegate).setLargeMaxRows(max);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return ((Statement)this.delegate).enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return ((Statement)this.delegate).enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return ((Statement)this.delegate).isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return ((Statement)this.delegate).enquoteNCharLiteral(val);
    }
}

