package cool.scx.jdbc.spy.wrapper;

import cool.scx.common.util.ArrayUtils;
import cool.scx.jdbc.spy.SpyEventListener;
import cool.scx.jdbc.spy.SpyWrapper;

import java.sql.*;

/**
 * StatementWrapper
 *
 * @author scx567888
 * @version 0.0.1
 */
public class StatementWrapper<T extends Statement> extends SpyWrapper<T> implements Statement {

    protected StatementWrapper(T delegate, SpyEventListener eventListener) {
        super(delegate, eventListener);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            return delegate.getResultSet();
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterGetResultSet(delegate, System.nanoTime() - start, e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeExecuteQuery(delegate, sql);
            return delegate.executeQuery(sql);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteQuery(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        int[] updateCounts = null;
        try {
            eventListener.onBeforeExecuteBatch(delegate);
            updateCounts = delegate.executeBatch();
            return updateCounts;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteBatch(delegate, System.nanoTime() - start, updateCounts == null ? null : ArrayUtils.toLongArray(updateCounts), e);
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        long[] updateCounts = null;
        try {
            eventListener.onBeforeExecuteBatch(delegate);
            updateCounts = delegate.executeLargeBatch();
            return updateCounts;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteBatch(delegate, System.nanoTime() - start, updateCounts, e);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(delegate, sql);
            return delegate.execute(sql);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecute(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(delegate, sql);
            return delegate.execute(sql, autoGeneratedKeys);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecute(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(delegate, sql);
            return delegate.execute(sql, columnIndexes);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecute(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeExecute(delegate, sql);
            return delegate.execute(sql, columnNames);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecute(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeUpdate(sql);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeUpdate(sql, autoGeneratedKeys);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeUpdate(sql, columnIndexes);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeUpdate(sql, columnNames);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0L;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeLargeUpdate(sql);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0L;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeLargeUpdate(sql, autoGeneratedKeys);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0L;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeLargeUpdate(sql, columnIndexes);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        var rowCount = 0L;
        try {
            eventListener.onBeforeExecuteUpdate(delegate, sql);
            rowCount = delegate.executeLargeUpdate(sql, columnNames);
            return rowCount;
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterExecuteUpdate(delegate, System.nanoTime() - start, sql, rowCount, e);
        }
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        SQLException e = null;
        var start = System.nanoTime();
        try {
            eventListener.onBeforeAddBatch(delegate, sql);
            delegate.addBatch(sql);
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterAddBatch(delegate, System.nanoTime() - start, sql, e);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLException e = null;
        try {
            delegate.close();
        } catch (SQLException s) {
            e = s;
            throw e;
        } finally {
            eventListener.onAfterStatementClose(delegate, e);
        }
    }

    // ********************************************
    //               以下为委托方法
    // ********************************************

    @Override
    public int getMaxFieldSize() throws SQLException {
        return delegate.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        delegate.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return delegate.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        delegate.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        delegate.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return delegate.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        delegate.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        delegate.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return delegate.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        delegate.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        delegate.setCursorName(name);
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return delegate.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return delegate.getMoreResults();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return delegate.getFetchDirection();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        delegate.setFetchDirection(direction);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return delegate.getFetchSize();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        delegate.setFetchSize(rows);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return delegate.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return delegate.getResultSetType();
    }


    @Override
    public void clearBatch() throws SQLException {
        delegate.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return delegate.getConnection();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return delegate.getMoreResults(current);
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return delegate.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return delegate.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return delegate.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return delegate.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        delegate.setPoolable(poolable);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        delegate.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return delegate.isCloseOnCompletion();
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return delegate.getLargeUpdateCount();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return delegate.getLargeMaxRows();
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        delegate.setLargeMaxRows(max);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        return delegate.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        return delegate.enquoteIdentifier(identifier, alwaysQuote);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return delegate.isSimpleIdentifier(identifier);
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return delegate.enquoteNCharLiteral(val);
    }

}
