/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.bean_builder.FieldSetter;
import cool.scx.jdbc.result_handler.bean_builder.NormalBeanBuilder;
import cool.scx.jdbc.result_handler.bean_builder.RecordBeanBuilder;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Function;

public abstract class BeanBuilder<T> {
    private Dialect lastDialect;

    public static <T> BeanBuilder<T> of(Class<T> type) {
        return type.isRecord() ? new RecordBeanBuilder<T>(type) : new NormalBeanBuilder<T>(type);
    }

    public static <T> BeanBuilder<T> of(Class<T> type, Function<Field, String> columnNameMapping) {
        return type.isRecord() ? new RecordBeanBuilder<T>(type, columnNameMapping) : new NormalBeanBuilder<T>(type, columnNameMapping);
    }

    public abstract T createBean(ResultSet var1, int[] var2) throws SQLException;

    abstract FieldSetter[] fieldSetters();

    public final int[] getIndexInfo(ResultSetMetaData rsm) throws SQLException {
        int count = rsm.getColumnCount();
        HashMap<String, Integer> nameIndexMap = new HashMap<String, Integer>();
        for (int i = 1; i <= count; ++i) {
            nameIndexMap.put(rsm.getColumnLabel(i), i);
        }
        FieldSetter[] setters = this.fieldSetters();
        int[] indexInfo = new int[setters.length];
        for (int i = 0; i < setters.length; ++i) {
            indexInfo[i] = nameIndexMap.getOrDefault(setters[i].columnName(), -1);
        }
        return indexInfo;
    }

    public final void bindDialect(Dialect dialect) {
        if (this.lastDialect != dialect) {
            this.lastDialect = dialect;
            for (FieldSetter fieldSetter : this.fieldSetters()) {
                TypeHandler<Object> typeHandler = this.lastDialect.findTypeHandler((Type)fieldSetter.fieldInfo().type());
                fieldSetter.bindTypeHandler(typeHandler);
            }
        }
    }
}

