/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mapping.base;

import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Index;
import cool.scx.jdbc.mapping.Key;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.mapping.base.BaseColumn;
import cool.scx.jdbc.mapping.base.BaseIndex;
import cool.scx.jdbc.mapping.base.BaseKey;
import java.util.HashMap;
import java.util.Map;

public class BaseTable
implements Table {
    private final Map<String, BaseColumn> columnMap = new HashMap<String, BaseColumn>();
    private final Map<String, BaseKey> keyMap = new HashMap<String, BaseKey>();
    private final Map<String, BaseIndex> indexMap = new HashMap<String, BaseIndex>();
    private String catalog;
    private String schema;
    private String name;

    public BaseTable() {
    }

    public BaseTable(Table oldTable) {
        this.setCatalog(oldTable.catalog());
        this.setSchema(oldTable.schema());
        this.setName(oldTable.name());
        for (Column column : oldTable.columns()) {
            this.addColumn(column);
        }
        for (Key key : oldTable.keys()) {
            this.addKey(key);
        }
        for (Index index : oldTable.indexes()) {
            this.addIndex(index);
        }
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public String name() {
        return this.name;
    }

    public BaseColumn[] columns() {
        return (BaseColumn[])this.columnMap.values().toArray(BaseColumn[]::new);
    }

    public BaseKey[] keys() {
        return (BaseKey[])this.keyMap.values().toArray(BaseKey[]::new);
    }

    public BaseIndex[] indexes() {
        return (BaseIndex[])this.indexMap.values().toArray(BaseIndex[]::new);
    }

    @Override
    public BaseColumn getColumn(String name) {
        return this.columnMap.get(name);
    }

    @Override
    public BaseKey getKey(String name) {
        return this.keyMap.get(name);
    }

    @Override
    public BaseIndex getIndex(String name) {
        return this.indexMap.get(name);
    }

    public BaseTable setCatalog(String catalog) {
        this.catalog = catalog;
        return this;
    }

    public BaseTable setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public BaseTable setName(String name) {
        this.name = name;
        return this;
    }

    public BaseTable addColumn(Column oldColumn) {
        BaseColumn column = new BaseColumn(oldColumn);
        this.columnMap.put(column.name(), column);
        return this;
    }

    public BaseTable removeColumn(String name) {
        this.columnMap.remove(name);
        return this;
    }

    public BaseTable clearColumns() {
        this.columnMap.clear();
        return this;
    }

    public BaseTable addKey(Key oldKey) {
        BaseKey key = new BaseKey(oldKey);
        this.keyMap.put(key.name(), key);
        return this;
    }

    public BaseTable removeKey(String name) {
        this.keyMap.remove(name);
        return this;
    }

    public BaseTable clearKeys() {
        this.keyMap.clear();
        return this;
    }

    public BaseTable addIndex(Index oldIndex) {
        BaseIndex index = new BaseIndex(oldIndex);
        this.indexMap.put(index.name(), index);
        return this;
    }

    public BaseTable removeIndex(String name) {
        this.indexMap.remove(name);
        return this;
    }

    public BaseTable clearIndexes() {
        this.indexMap.clear();
        return this;
    }
}

