/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NamedSQL
implements SQL {
    private final String sql;
    private final Object[] params;
    private final List<Object[]> batchParams;
    private final boolean isBatch;

    NamedSQL(String namedSQL, Map<String, Object> params) {
        NormalSQLParser parser = NormalSQLParser.parse(namedSQL);
        this.sql = parser.normalSQL();
        this.params = parser.mapToArray(params);
        this.batchParams = new ArrayList<Object[]>();
        this.isBatch = false;
    }

    NamedSQL(String namedSQL, List<Map<String, Object>> batchParams) {
        NormalSQLParser parser = NormalSQLParser.parse(namedSQL);
        this.sql = parser.normalSQL();
        this.params = new Object[0];
        this.batchParams = parser.mapToArray(batchParams);
        this.isBatch = true;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public Object[] params() {
        return this.params;
    }

    @Override
    public List<Object[]> batchParams() {
        return this.batchParams;
    }

    @Override
    public boolean isBatch() {
        return this.isBatch;
    }

    private record NormalSQLParser(String normalSQL, String[] nameIndex) {
        private static final Pattern NAMED_SQL_PATTERN = Pattern.compile(":([\\w.-]+)");

        private static NormalSQLParser parse(String namedSQL) {
            Matcher matcher = NAMED_SQL_PATTERN.matcher(namedSQL);
            StringBuilder normalSQL = new StringBuilder();
            ArrayList<String> tempNameIndexList = new ArrayList<String>();
            while (matcher.find()) {
                matcher.appendReplacement(normalSQL, "?");
                tempNameIndexList.add(matcher.group(1));
            }
            matcher.appendTail(normalSQL);
            return new NormalSQLParser(normalSQL.toString(), (String[])tempNameIndexList.toArray(String[]::new));
        }

        private Object[] mapToArray(Map<String, Object> objectMap) {
            Object[] objectArray = new Object[this.nameIndex.length];
            for (int i = 0; i < this.nameIndex.length; ++i) {
                objectArray[i] = objectMap.get(this.nameIndex[i]);
            }
            return objectArray;
        }

        private List<Object[]> mapToArray(List<Map<String, Object>> listObjectMap) {
            return listObjectMap.stream().map(this::mapToArray).toList();
        }
    }
}

