/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.sql.NamedSQLListParameter;
import cool.scx.jdbc.sql.SQL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NamedSQL
implements SQL {
    private static final Pattern NAMED_SQL_PATTERN = Pattern.compile(":([\\w.-]+)");
    private final String sql;
    private final Object[] params;
    private final List<Object[]> batchParams;
    private final boolean isBatch;

    NamedSQL(String namedSQL, Map<String, Object> params) {
        Matcher matcher = NAMED_SQL_PATTERN.matcher(namedSQL);
        StringBuilder tempSQL = new StringBuilder();
        ArrayList<Object> tempParams = new ArrayList<Object>();
        while (matcher.find()) {
            String g = matcher.group(1);
            Object value = params.get(g);
            if (value instanceof NamedSQLListParameter) {
                NamedSQLListParameter n = (NamedSQLListParameter)value;
                Collection<?> values = n.values();
                tempParams.addAll(values);
                matcher.appendReplacement(tempSQL, StringUtils.repeat((String)"?", (String)", ", (int)values.size()));
                continue;
            }
            tempParams.add(value);
            matcher.appendReplacement(tempSQL, "?");
        }
        matcher.appendTail(tempSQL);
        this.sql = tempSQL.toString();
        this.params = tempParams.toArray();
        this.batchParams = new ArrayList<Object[]>();
        this.isBatch = false;
    }

    NamedSQL(String namedSQL, List<Map<String, Object>> batchParams) {
        Matcher matcher = NAMED_SQL_PATTERN.matcher(namedSQL);
        StringBuilder tempSQL = new StringBuilder();
        ArrayList<String> tempNameIndex = new ArrayList<String>();
        while (matcher.find()) {
            String g = matcher.group(1);
            tempNameIndex.add(g);
            matcher.appendReplacement(tempSQL, "?");
        }
        matcher.appendTail(tempSQL);
        String[] nameIndex = (String[])tempNameIndex.toArray(String[]::new);
        ArrayList<Object[]> tempBatchParams = new ArrayList<Object[]>();
        for (Map<String, Object> p : batchParams) {
            Object[] o = new Object[nameIndex.length];
            for (int i = 0; i < nameIndex.length; ++i) {
                o[i] = p.get(nameIndex[i]);
            }
            tempBatchParams.add(o);
        }
        this.sql = tempSQL.toString();
        this.params = new Object[0];
        this.batchParams = tempBatchParams;
        this.isBatch = true;
    }

    @Override
    public String sql() {
        return this.sql;
    }

    @Override
    public Object[] params() {
        return this.params;
    }

    @Override
    public List<Object[]> batchParams() {
        return this.batchParams;
    }

    @Override
    public boolean isBatch() {
        return this.isBatch;
    }
}

