/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;

public final class SQLBuilder {
    private final SQLBuilderType sqlBuilderType;
    private Object[] selectColumns = null;
    private Object tableName = null;
    private String whereClause = null;
    private Object[] groupByColumns = null;
    private String[] orderByClauses = null;
    private Long offset = null;
    private Long limit = null;
    private Object[] insertColumns = null;
    private String[] insertValues = null;
    private String[] updateSetClauses = null;

    private SQLBuilder(SQLBuilderType sqlBuilderType) {
        this.sqlBuilderType = sqlBuilderType;
    }

    public static SQLBuilder Select(String ... selectColumns) {
        return new SQLBuilder(SQLBuilderType.SELECT)._Select(selectColumns);
    }

    public static SQLBuilder Select(Column ... selectColumns) {
        return new SQLBuilder(SQLBuilderType.SELECT)._Select(selectColumns);
    }

    public static SQLBuilder Select(Object ... selectColumns) {
        return new SQLBuilder(SQLBuilderType.SELECT)._Select(selectColumns);
    }

    public static SQLBuilder Insert(String tableName, String ... insertColumns) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(tableName, insertColumns);
    }

    public static SQLBuilder Insert(String tableName, Column ... insertColumnInfos) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(tableName, insertColumnInfos);
    }

    public static SQLBuilder Insert(Table table, Column ... insertColumnInfos) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(table, insertColumnInfos);
    }

    public static SQLBuilder Insert(Table table, String ... insertColumns) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(table, insertColumns);
    }

    public static SQLBuilder Insert(Table table, Object ... insertColumnInfos) {
        return new SQLBuilder(SQLBuilderType.INSERT)._Insert(table, insertColumnInfos);
    }

    public static SQLBuilder Update(String tableName) {
        return new SQLBuilder(SQLBuilderType.UPDATE)._Update(tableName);
    }

    public static SQLBuilder Update(Table table) {
        return new SQLBuilder(SQLBuilderType.UPDATE)._Update(table);
    }

    public static SQLBuilder Delete(String tableName) {
        return new SQLBuilder(SQLBuilderType.DELETE)._Delete(tableName);
    }

    public static SQLBuilder Delete(Table table) {
        return new SQLBuilder(SQLBuilderType.DELETE)._Delete(table);
    }

    private static String joinWithQuoteIdentifier(Object[] values, Dialect dialect) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder();
        for (Object value : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            if (value instanceof Column) {
                Column c = (Column)value;
                sb.append(dialect.quoteIdentifier(c.name()));
                continue;
            }
            sb.append(value.toString());
        }
        return sb.toString();
    }

    private SQLBuilder _Select(Object[] selectColumns) {
        if (selectColumns.length == 0) {
            throw new IllegalArgumentException("Select \u5b50\u53e5\u9519\u8bef : \u5f85\u67e5\u8be2\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.selectColumns = selectColumns;
        return this;
    }

    public SQLBuilder From(Table table) {
        this.tableName = table;
        return this;
    }

    public SQLBuilder From(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SQLBuilder Where(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public SQLBuilder GroupBy(String ... groupByColumns) {
        this.groupByColumns = groupByColumns;
        return this;
    }

    public SQLBuilder GroupBy(Column ... groupByColumns) {
        this.groupByColumns = groupByColumns;
        return this;
    }

    public SQLBuilder OrderBy(String ... orderByClauses) {
        this.orderByClauses = orderByClauses;
        return this;
    }

    public SQLBuilder Limit(Long offset, Long limit) {
        if (offset != null && offset < 0L) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : offset (\u504f\u79fb\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        if (limit != null && limit < 0L) {
            throw new IllegalArgumentException("\u5206\u9875\u53c2\u6570\u9519\u8bef : limit (\u6bcf\u9875\u6570\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.offset = offset;
        this.limit = limit;
        return this;
    }

    public SQLBuilder Limit(Long size) {
        return this.Limit(0L, size);
    }

    private SQLBuilder _Insert(Object tableName, Object[] insertColumns) {
        this.tableName = tableName;
        this.insertColumns = insertColumns;
        return this;
    }

    public SQLBuilder Values(String ... insertValues) {
        this.insertValues = insertValues;
        return this;
    }

    private SQLBuilder _Update(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    public SQLBuilder Set(String ... updateSetClauses) {
        if (updateSetClauses.length == 0) {
            throw new IllegalArgumentException("Set \u5b50\u53e5\u9519\u8bef : \u5f85\u66f4\u65b0\u7684\u6570\u636e\u5217 \u4e0d\u80fd\u4e3a\u7a7a !!!");
        }
        this.updateSetClauses = updateSetClauses;
        return this;
    }

    public SQLBuilder _Delete(Object tableName) {
        this.tableName = tableName;
        return this;
    }

    public String GetSQL(Dialect dialect) {
        return switch (this.sqlBuilderType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.GetInsertSQL(dialect);
            case 2 -> this.GetUpdateSQL(dialect);
            case 1 -> this.GetDeleteSQL(dialect);
            case 3 -> this.GetSelectSQL(dialect);
        };
    }

    private String GetInsertSQL(Dialect dialect) {
        return "INSERT INTO " + this.getTableName(dialect) + " (" + this.getInsertColumns(dialect) + ") VALUES (" + String.join((CharSequence)", ", this.insertValues) + ")";
    }

    private String GetUpdateSQL(Dialect dialect) {
        String sql = "UPDATE " + this.getTableName(dialect) + " SET " + String.join((CharSequence)", ", this.updateSetClauses) + this.getWhereClause() + this.getOrderByClause();
        return dialect.getLimitSQL(sql, null, this.limit);
    }

    private String GetDeleteSQL(Dialect dialect) {
        String sql = "DELETE FROM " + this.getTableName(dialect) + this.getWhereClause() + this.getOrderByClause();
        return dialect.getLimitSQL(sql, null, this.limit);
    }

    private String GetSelectSQL(Dialect dialect) {
        String sql = "SELECT " + this.getSelectColumns(dialect) + " FROM " + this.getTableName(dialect) + this.getWhereClause() + this.getGroupByClause(dialect) + this.getOrderByClause();
        return dialect.getLimitSQL(sql, this.offset, this.limit);
    }

    private String getWhereClause() {
        return StringUtils.notEmpty((String)this.whereClause) ? " WHERE " + this.whereClause : "";
    }

    private String getGroupByClause(Dialect dialect) {
        return this.groupByColumns != null && this.groupByColumns.length != 0 ? " GROUP BY " + this.getGroupByColumns(dialect) : "";
    }

    private String getOrderByClause() {
        return this.orderByClauses != null && this.orderByClauses.length != 0 ? " ORDER BY " + String.join((CharSequence)", ", this.orderByClauses) : "";
    }

    private String getInsertColumns(Dialect dialect) {
        return SQLBuilder.joinWithQuoteIdentifier(this.insertColumns, dialect);
    }

    private String getSelectColumns(Dialect dialect) {
        return SQLBuilder.joinWithQuoteIdentifier(this.selectColumns, dialect);
    }

    private String getGroupByColumns(Dialect dialect) {
        return SQLBuilder.joinWithQuoteIdentifier(this.groupByColumns, dialect);
    }

    private String getTableName(Dialect dialect) {
        Object object = this.tableName;
        if (object instanceof Table) {
            Table t = (Table)object;
            return dialect.quoteIdentifier(t.name());
        }
        return this.tableName.toString();
    }

    private static enum SQLBuilderType {
        INSERT,
        DELETE,
        UPDATE,
        SELECT;

    }
}

