/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler.time;

import cool.scx.common.constant.ScxDateTimeFormatter;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.time.LocalTime;

public class LocalTimeTypeHandler
implements TypeHandler<LocalTime> {
    @Override
    public void setObject(PreparedStatement ps, int i, LocalTime parameter) throws SQLException {
        try {
            ps.setObject(i, parameter);
        }
        catch (SQLFeatureNotSupportedException e) {
            ps.setString(i, ScxDateTimeFormatter.HH_mm_ss.format(parameter));
        }
    }

    @Override
    public LocalTime getObject(ResultSet rs, int columnIndex) throws SQLException {
        try {
            return rs.getObject(columnIndex, LocalTime.class);
        }
        catch (SQLFeatureNotSupportedException e) {
            String str = rs.getString(columnIndex);
            return str == null ? null : ScxDateTimeFormatter.HH_mm_ss.parse((CharSequence)str, LocalTime::from);
        }
    }
}

