/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mapping.base;

import cool.scx.jdbc.mapping.Catalog;
import cool.scx.jdbc.mapping.Schema;
import cool.scx.jdbc.mapping.base.BaseSchema;
import java.util.HashMap;
import java.util.Map;

public class BaseCatalog
implements Catalog {
    private final Map<String, BaseSchema> schemaMap = new HashMap<String, BaseSchema>();
    private String name;

    public BaseCatalog() {
    }

    public BaseCatalog(Catalog oldCatalog) {
        this.setName(oldCatalog.name());
        for (Schema schema : oldCatalog.schemas()) {
            this.addSchema(schema);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    public BaseSchema[] schemas() {
        return (BaseSchema[])this.schemaMap.values().toArray(BaseSchema[]::new);
    }

    @Override
    public BaseSchema getSchema(String name) {
        return this.schemaMap.get(name);
    }

    public BaseCatalog setName(String name) {
        this.name = name;
        return this;
    }

    public BaseCatalog addSchema(Schema oldSchema) {
        BaseSchema schema = new BaseSchema(oldSchema);
        this.schemaMap.put(schema.name(), schema);
        return this;
    }

    public BaseCatalog removeSchema(String name) {
        this.schemaMap.remove(name);
        return this;
    }

    public BaseCatalog clearSchemas() {
        this.schemaMap.clear();
        return this;
    }
}

