/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.meta_data.ColumnMetaData;
import cool.scx.jdbc.meta_data.IndexMetaData;
import cool.scx.jdbc.meta_data.KeyMetaData;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class TableMetaData
implements Table {
    private final String catalog;
    private final String schema;
    private final String name;
    private final String remarks;
    private ColumnMetaData[] columns;
    private KeyMetaData[] keys;
    private IndexMetaData[] indexes;
    private Map<String, ColumnMetaData> columnMap = new HashMap<String, ColumnMetaData>();

    public TableMetaData(String catalog, String schema, String name, String remarks) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.remarks = remarks;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String remarks() {
        return this.remarks;
    }

    public ColumnMetaData[] columns() {
        return this.columns;
    }

    public KeyMetaData[] keys() {
        return this.keys;
    }

    public IndexMetaData[] indexes() {
        return this.indexes;
    }

    @Override
    public ColumnMetaData getColumn(String column) {
        return this.columnMap.get(column);
    }

    public TableMetaData refreshColumns(Connection connection) throws SQLException {
        this.keys = MetaDataHelper.getKeys(connection, this.catalog, this.schema, this.name);
        this.indexes = MetaDataHelper.getIndexes(connection, this.catalog, this.schema, this.name, false, false);
        this.columns = MetaDataHelper.getColumns(connection, this.catalog, this.schema, this.name, null, this);
        this.columnMap = Arrays.stream(this.columns).collect(Collectors.toMap(ColumnMetaData::name, c -> c));
        return this;
    }
}

