/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.bean_builder.FieldSetter;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ClassInfoFactory;
import cool.scx.reflect.ConstructorInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;

final class NormalBeanBuilder<T>
extends BeanBuilder<T> {
    private final ConstructorInfo constructor;
    private final FieldSetter[] fieldSetters;

    public NormalBeanBuilder(Class<T> type, Function<Field, String> columnNameMapping) {
        this.constructor = NormalBeanBuilder.checkDefaultConstructor(ClassInfoFactory.getClassInfo(type));
        this.constructor.setAccessible(true);
        this.fieldSetters = FieldSetter.ofArray(type, columnNameMapping);
    }

    public NormalBeanBuilder(Class<T> type) {
        this(type, Field::getName);
    }

    private static ConstructorInfo checkDefaultConstructor(ClassInfo classInfo) {
        ConstructorInfo defaultConstructor = classInfo.defaultConstructor();
        if (defaultConstructor == null) {
            throw new IllegalArgumentException("\u5bfb\u627e \u65e0\u53c2 \u6784\u9020\u51fd\u6570\u5931\u8d25, type " + classInfo.name());
        }
        return defaultConstructor;
    }

    @Override
    public T createBean(ResultSet rs, int[] indexInfo) throws SQLException {
        T t = this.newInstance();
        for (int i = 0; i < this.fieldSetters.length; ++i) {
            Object o;
            if (indexInfo[i] == -1 || (o = this.fieldSetters[i].typeHandler().getObject(rs, indexInfo[i])) == null) continue;
            try {
                this.fieldSetters[i].fieldInfo().set(t, o);
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return t;
    }

    @Override
    public FieldSetter[] fieldSetters() {
        return this.fieldSetters;
    }

    private T newInstance() {
        try {
            return (T)this.constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

