/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.mapping.base;

import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.DataType;
import cool.scx.jdbc.mapping.base.BaseDataType;

public class BaseColumn
implements Column {
    private String table;
    private String name;
    private BaseDataType dataType;
    private String defaultValue;
    private String onUpdate;
    private boolean notNull;
    private boolean autoIncrement;
    private boolean primary;
    private boolean unique;
    private boolean index;
    private String comment;

    public BaseColumn() {
    }

    public BaseColumn(Column oldColumn) {
        this.setTable(oldColumn.table());
        this.setName(oldColumn.name());
        this.setDataType(oldColumn.dataType());
        this.setDefaultValue(oldColumn.defaultValue());
        this.setOnUpdate(oldColumn.onUpdate());
        this.setNotNull(oldColumn.notNull());
        this.setAutoIncrement(oldColumn.autoIncrement());
        this.setPrimary(oldColumn.primary());
        this.setUnique(oldColumn.unique());
        this.setIndex(oldColumn.index());
        this.setComment(oldColumn.comment());
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public BaseDataType dataType() {
        return this.dataType;
    }

    @Override
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    public String onUpdate() {
        return this.onUpdate;
    }

    @Override
    public boolean notNull() {
        return this.notNull;
    }

    @Override
    public boolean autoIncrement() {
        return this.autoIncrement;
    }

    @Override
    public boolean primary() {
        return this.primary;
    }

    @Override
    public boolean unique() {
        return this.unique;
    }

    @Override
    public boolean index() {
        return this.index;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    public BaseColumn setTable(String table) {
        this.table = table;
        return this;
    }

    public BaseColumn setName(String name) {
        this.name = name;
        return this;
    }

    public BaseColumn setDataType(DataType dataType) {
        this.dataType = new BaseDataType(dataType);
        return this;
    }

    public BaseColumn setDataType(String name) {
        this.dataType = new BaseDataType(name);
        return this;
    }

    public BaseColumn setDataType(String name, Integer length) {
        this.dataType = new BaseDataType(name, length);
        return this;
    }

    public BaseColumn setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public BaseColumn setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public BaseColumn setNotNull(boolean notNull) {
        this.notNull = notNull;
        return this;
    }

    public BaseColumn setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
        return this;
    }

    public BaseColumn setPrimary(boolean primary) {
        this.primary = primary;
        return this;
    }

    public BaseColumn setUnique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public BaseColumn setIndex(boolean index) {
        this.index = index;
        return this;
    }

    public BaseColumn setComment(String comment) {
        this.comment = comment;
        return this;
    }
}

