/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc;

import cool.scx.common.util.StringUtils;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import cool.scx.jdbc.meta_data.TableMetaData;
import cool.scx.jdbc.sql.SQL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.DataSource;

public final class SchemaHelper {
    public static String getMigrateSQL(Table oldTable, Table newTable, Dialect dialect) {
        TableVerifyResult verifyResult = SchemaHelper.verifyTable(oldTable, newTable);
        Column[] needAdd = verifyResult.needAdd();
        if (needAdd.length > 0) {
            return dialect.getAlterTableDDL(needAdd, newTable);
        }
        return null;
    }

    public static TableVerifyResult verifyTable(Table oldTable, Table newTable) {
        Column column;
        ArrayList<Column> needAdd = new ArrayList<Column>();
        ArrayList<Column> needRemove = new ArrayList<Column>();
        ArrayList needChange = new ArrayList();
        for (Column oldColumn : oldTable.columns()) {
            column = newTable.getColumn(oldColumn.name());
            if (column != null) continue;
            needRemove.add(oldColumn);
        }
        for (Column newColumn : newTable.columns()) {
            column = oldTable.getColumn(newColumn.name());
            if (column != null) continue;
            needAdd.add(newColumn);
        }
        return new TableVerifyResult((Column[])needAdd.toArray(Column[]::new), (Column[])needRemove.toArray(Column[]::new), (Column[])needChange.toArray(Column[]::new));
    }

    public static void fixTable(Table tableInfo, JDBCContext jdbcContext) throws SQLException {
        try (Connection con = jdbcContext.dataSource().getConnection();){
            String fixTableSQL;
            TableMetaData tableMetaData = MetaDataHelper.getCurrentSchema(con).refreshTables(con).getTable(tableInfo.name());
            String string = fixTableSQL = tableMetaData == null ? jdbcContext.dialect().getCreateTableDDL(tableInfo) : SchemaHelper.getMigrateSQL(tableMetaData.refreshColumns(con), tableInfo, jdbcContext.dialect());
            if (StringUtils.notBlank((String)fixTableSQL)) {
                jdbcContext.sqlRunner().execute(con, SQL.sql(fixTableSQL, new Object[0]));
            }
        }
    }

    public static boolean checkNeedFixTable(Table tableInfo, DataSource dataSource) throws SQLException {
        try (Connection con = dataSource.getConnection();){
            TableMetaData tableMetaData = MetaDataHelper.getCurrentSchema(con).refreshTables(con).getTable(tableInfo.name());
            boolean bl = tableMetaData == null || SchemaHelper.verifyTable(tableMetaData.refreshColumns(con), tableInfo).needAdd().length > 0;
            return bl;
        }
    }

    public record TableVerifyResult(Column[] needAdd, Column[] needRemove, Column[] needChange) {
    }
}

