/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

record MapHandler(MapBuilder mapBuilder) implements ResultHandler<Map<String, Object>, RuntimeException>
{
    static final MapHandler INSTANCE = new MapHandler(MapBuilder.of());

    public static String[] createColumnLabelIndex(ResultSet rs) throws SQLException {
        ResultSetMetaData rsm = rs.getMetaData();
        int count = rsm.getColumnCount();
        String[] columnLabelIndex = new String[count + 1];
        for (int i = 1; i <= count; ++i) {
            columnLabelIndex[i] = rsm.getColumnLabel(i);
        }
        return columnLabelIndex;
    }

    @Override
    public Map<String, Object> apply(ResultSet rs, Dialect dialect) throws SQLException {
        String[] columnLabelIndex = MapHandler.createColumnLabelIndex(rs);
        if (rs.next()) {
            return this.mapBuilder.createMap(rs, columnLabelIndex);
        }
        return null;
    }
}

