/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.meta_data.ColumnMetaData;
import cool.scx.jdbc.meta_data.IndexMetaData;
import cool.scx.jdbc.meta_data.KeyMetaData;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import java.sql.Connection;
import java.sql.SQLException;

public final class TableMetaData
implements Table {
    private final String catalog;
    private final String schema;
    private final String name;
    private final String remarks;
    private ColumnMetaData[] columns;
    private KeyMetaData[] keys;
    private IndexMetaData[] indexes;

    public TableMetaData(String catalog, String schema, String name, String remarks) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
        this.remarks = remarks;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String remarks() {
        return this.remarks;
    }

    public ColumnMetaData[] columns() {
        return this.columns;
    }

    public KeyMetaData[] keys() {
        return this.keys;
    }

    public IndexMetaData[] indexes() {
        return this.indexes;
    }

    public TableMetaData refreshColumns(Connection connection, Dialect dialect) throws SQLException {
        this.keys = MetaDataHelper.getKeys(connection, this.catalog, this.schema, this.name);
        this.indexes = MetaDataHelper.getIndexes(connection, this.catalog, this.schema, this.name, false, false);
        this.columns = MetaDataHelper.getColumns(connection, this.catalog, this.schema, this.name, null, this, dialect);
        return this;
    }
}

