/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.map_builder;

import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

record DefaultMapBuilder(Supplier<Map<String, Object>> mapSupplier, Function<String, String> fieldNameMapping) implements MapBuilder
{
    public static final MapBuilder MAP_BUILDER = new DefaultMapBuilder(HashMap::new, c -> c);

    @Override
    public Map<String, Object> createMap(ResultSet rs, String[] columnLabelIndex) throws SQLException {
        Map<String, Object> map = this.mapSupplier.get();
        for (int i = 1; i < columnLabelIndex.length; ++i) {
            String columnLabel = columnLabelIndex[i];
            String fieldName = this.fieldNameMapping.apply(columnLabel);
            if (fieldName == null) {
                fieldName = columnLabel;
            }
            Object value = rs.getObject(i);
            map.put(fieldName, value);
        }
        return map;
    }
}

