/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.meta_data.CatalogMetaData;
import cool.scx.jdbc.meta_data.ColumnMetaData;
import cool.scx.jdbc.meta_data.DataTypeMetaData;
import cool.scx.jdbc.meta_data.IndexMetaData;
import cool.scx.jdbc.meta_data.KeyMetaData;
import cool.scx.jdbc.meta_data.SchemaMetaData;
import cool.scx.jdbc.meta_data.TableMetaData;
import cool.scx.jdbc.result_handler.ResultHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.List;
import java.util.Objects;

public final class MetaDataHelper {
    private static final ResultHandler<List<_Catalog>> CATALOG_LIST_HANDLER = ResultHandler.ofBeanList(_Catalog.class);
    private static final ResultHandler<List<_Schema>> SCHEMA_LIST_HANDLER = ResultHandler.ofBeanList(_Schema.class);
    private static final ResultHandler<List<_Table>> TABLE_LIST_HANDLER = ResultHandler.ofBeanList(_Table.class);
    private static final ResultHandler<List<_Column>> COLUMN_LIST_HANDLER = ResultHandler.ofBeanList(_Column.class);
    private static final ResultHandler<List<_Key>> KEY_LIST_HANDLER = ResultHandler.ofBeanList(_Key.class);
    private static final ResultHandler<List<_Index>> INDEX_INFO_LIST_HANDLER = ResultHandler.ofBeanList(_Index.class);

    public static CatalogMetaData[] getCatalogs(Connection con) throws SQLException {
        try {
            CatalogMetaData[] catalogs = (CatalogMetaData[])CATALOG_LIST_HANDLER.apply(con.getMetaData().getCatalogs()).stream().map(_Catalog::toCatalogMetaData).toArray(CatalogMetaData[]::new);
            if (catalogs.length > 0) {
                return catalogs;
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        return new CatalogMetaData[]{new CatalogMetaData(null)};
    }

    public static SchemaMetaData[] getSchemas(Connection con, String catalog, String schemaPattern) throws SQLException {
        try {
            SchemaMetaData[] schemas = (SchemaMetaData[])SCHEMA_LIST_HANDLER.apply(con.getMetaData().getSchemas(catalog, schemaPattern)).stream().map(_Schema::toSchemaMetaData).toArray(SchemaMetaData[]::new);
            if (schemas.length > 0) {
                return schemas;
            }
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
        return new SchemaMetaData[]{new SchemaMetaData(catalog, null)};
    }

    public static TableMetaData[] getTables(Connection connection, String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        return (TableMetaData[])TABLE_LIST_HANDLER.apply(connection.getMetaData().getTables(catalog, schemaPattern, tableNamePattern, types)).stream().map(_Table::toTableMetaData).toArray(TableMetaData[]::new);
    }

    public static ColumnMetaData[] getColumns(Connection connection, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, TableMetaData tableMetaData, Dialect dialect) throws SQLException {
        return (ColumnMetaData[])COLUMN_LIST_HANDLER.apply(connection.getMetaData().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern)).stream().map(column -> column.toColumnMetaData(tableMetaData, dialect)).toArray(ColumnMetaData[]::new);
    }

    public static KeyMetaData[] getKeys(Connection connection, String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return (KeyMetaData[])KEY_LIST_HANDLER.apply(connection.getMetaData().getPrimaryKeys(catalog, schemaPattern, tableNamePattern)).stream().map(_Key::toKeyMetaData).toArray(KeyMetaData[]::new);
    }

    public static IndexMetaData[] getIndexes(Connection connection, String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return (IndexMetaData[])INDEX_INFO_LIST_HANDLER.apply(connection.getMetaData().getIndexInfo(catalog, schema, table, unique, approximate)).stream().map(_Index::toIndexMetaData).toArray(IndexMetaData[]::new);
    }

    public static SchemaMetaData getCurrentSchema(Connection con) throws SQLException {
        return MetaDataHelper.getSchemas(con, con.getCatalog(), con.getSchema())[0];
    }

    private record _Column(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String COLUMN_NAME, int DATA_TYPE, String TYPE_NAME, int COLUMN_SIZE, String BUFFER_LENGTH, int DECIMAL_DIGITS, int NUM_PREC_RADIX, int NULLABLE, String REMARKS, String COLUMN_DEF, int SQL_DATA_TYPE, int SQL_DATETIME_SUB, int CHAR_OCTET_LENGTH, int ORDINAL_POSITION, String IS_NULLABLE, String SCOPE_CATALOG, String SCOPE_SCHEMA, String SCOPE_TABLE, short SOURCE_DATA_TYPE, String IS_AUTOINCREMENT, String IS_GENERATEDCOLUMN) {
        private static boolean checkPrimaryKey(TableMetaData table, String columnName) {
            for (KeyMetaData primaryKey : table.keys()) {
                if (!Objects.equals(primaryKey.columnName(), columnName)) continue;
                return true;
            }
            return false;
        }

        private static IndexMetaData checkIndex(TableMetaData table, String columnName) {
            for (IndexMetaData indexInfoMetaData : table.indexes()) {
                if (!Objects.equals(indexInfoMetaData.columnName(), columnName)) continue;
                return indexInfoMetaData;
            }
            return null;
        }

        public ColumnMetaData toColumnMetaData(TableMetaData tableMetaData, Dialect dialect) {
            DataTypeMetaData dataType = new DataTypeMetaData(dialect.dialectDataTypeToJDBCType(this.TYPE_NAME), this.TYPE_NAME, this.COLUMN_SIZE);
            boolean notNull = Objects.equals("NO", this.IS_NULLABLE);
            boolean autoincrement = Objects.equals("YES", this.IS_AUTOINCREMENT);
            boolean primary = _Column.checkPrimaryKey(tableMetaData, this.COLUMN_NAME);
            boolean index = false;
            boolean unique = false;
            IndexMetaData indexMetaData = _Column.checkIndex(tableMetaData, this.COLUMN_NAME);
            if (indexMetaData != null) {
                index = true;
                if (indexMetaData.unique()) {
                    unique = true;
                }
            }
            return new ColumnMetaData(this.TABLE_NAME, this.COLUMN_NAME, dataType, this.COLUMN_DEF, null, notNull, autoincrement, primary, unique, index, this.REMARKS);
        }
    }

    private record _Catalog(String TABLE_CAT) {
        public CatalogMetaData toCatalogMetaData() {
            return new CatalogMetaData(this.TABLE_CAT);
        }
    }

    private record _Schema(String TABLE_SCHEM, String TABLE_CATALOG) {
        public SchemaMetaData toSchemaMetaData() {
            return new SchemaMetaData(this.TABLE_CATALOG, this.TABLE_SCHEM);
        }
    }

    private record _Table(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String TABLE_TYPE, String REMARKS, String TYPE_CAT, String TYPE_SCHEM, String TYPE_NAME, String SELF_REFERENCING_COL_NAME, String REF_GENERATION) {
        public TableMetaData toTableMetaData() {
            return new TableMetaData(this.TABLE_CAT, this.TABLE_SCHEM, this.TABLE_NAME, this.REMARKS);
        }
    }

    private record _Key(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, String COLUMN_NAME, short KEY_SEQ, String PK_NAME) {
        public KeyMetaData toKeyMetaData() {
            return new KeyMetaData(this.PK_NAME, this.COLUMN_NAME, true);
        }
    }

    private record _Index(String TABLE_CAT, String TABLE_SCHEM, String TABLE_NAME, boolean NON_UNIQUE, String INDEX_QUALIFIER, String INDEX_NAME, short TYPE, short ORDINAL_POSITION, String COLUMN_NAME, String ASC_OR_DESC, long CARDINALITY, long PAGES, String FILTER_CONDITION) {
        public IndexMetaData toIndexMetaData() {
            return new IndexMetaData(this.INDEX_NAME, this.COLUMN_NAME, !this.NON_UNIQUE);
        }
    }
}

