/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Schema;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import cool.scx.jdbc.meta_data.TableMetaData;
import java.sql.Connection;
import java.sql.SQLException;

public final class SchemaMetaData
implements Schema {
    private final String catalog;
    private final String name;
    private TableMetaData[] tables;

    public SchemaMetaData(String catalog, String name) {
        this.catalog = catalog;
        this.name = name;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String name() {
        return this.name;
    }

    public TableMetaData[] tables() {
        return this.tables;
    }

    public SchemaMetaData refreshTables(Connection connection) throws SQLException {
        this.tables = MetaDataHelper.getTables(connection, this.catalog, this.name, null, new String[]{"TABLE"});
        return this;
    }

    public SchemaMetaData refreshTablesDeep(Connection connection, Dialect dialect) throws SQLException {
        this.refreshTables(connection);
        for (TableMetaData table : this.tables) {
            table.refreshColumns(connection, dialect);
        }
        return this;
    }

    public SchemaMetaData refreshTables(Connection connection, String[] types) throws SQLException {
        this.tables = MetaDataHelper.getTables(connection, this.catalog, this.name, null, types);
        return this;
    }

    public SchemaMetaData refreshTablesDeep(Connection connection, String[] types, Dialect dialect) throws SQLException {
        for (TableMetaData table : this.tables = MetaDataHelper.getTables(connection, this.catalog, this.name, null, types)) {
            table.refreshColumns(connection, dialect);
        }
        return this;
    }

    public TableMetaData getTable(Connection con, String name) throws SQLException {
        TableMetaData[] tables = MetaDataHelper.getTables(con, this.catalog, this.name, name, new String[]{"TABLE"});
        if (tables.length == 1) {
            return tables[0];
        }
        return null;
    }
}

