/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.functional.ScxCallable;
import cool.scx.functional.ScxConsumer;
import cool.scx.functional.ScxFunction;
import cool.scx.functional.ScxRunnable;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLRunnerException;
import cool.scx.jdbc.sql.UpdateResult;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

public final class SQLRunner {
    private static final InheritableThreadLocal<Connection> CONNECTION_THREAD_LOCAL = new InheritableThreadLocal();
    private final AtomicLong threadNumber = new AtomicLong(0L);
    private final JDBCContext jdbcContext;

    public SQLRunner(JDBCContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    public static void autoTransaction(Connection con, ScxConsumer<Connection, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            handler.accept((Object)con);
            con.commit();
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    public static <T> T autoTransaction(Connection con, ScxFunction<Connection, T, Exception> handler) throws Exception {
        con.setAutoCommit(false);
        try {
            Object result = handler.apply((Object)con);
            con.commit();
            return (T)result;
        }
        catch (Exception e) {
            con.rollback();
            throw e;
        }
    }

    private static List<Long> getGeneratedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    private static PreparedStatement fillParams(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        return sql.isBatch() ? SQLRunner.fillBatch(sql, preparedStatement, typeHandlerSelector) : SQLRunner.fillSingle(sql, preparedStatement, typeHandlerSelector);
    }

    private static PreparedStatement fillSingle(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.params() != null) {
            SQLRunner.fillPreparedStatement(preparedStatement, sql.params(), typeHandlerSelector);
        }
        return preparedStatement;
    }

    private static PreparedStatement fillBatch(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.batchParams() != null) {
            for (Object[] paramArray : sql.batchParams()) {
                if (paramArray == null) continue;
                SQLRunner.fillPreparedStatement(preparedStatement, paramArray, typeHandlerSelector);
                preparedStatement.addBatch();
            }
        }
        return preparedStatement;
    }

    private static void fillPreparedStatement(PreparedStatement preparedStatement, Object[] params, Dialect dialect) throws SQLException {
        int index = 1;
        for (Object tempValue : params) {
            if (tempValue == null) {
                preparedStatement.setNull(index, 0);
            } else {
                TypeHandler<Object> typeHandler = dialect.findTypeHandler(tempValue.getClass());
                typeHandler.setObject(preparedStatement, index, tempValue);
            }
            ++index;
        }
    }

    public <T> T query(Connection con, SQL sql, ResultHandler<T> resultHandler) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1003, 1007);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            this.jdbcContext.dialect().beforeExecuteQuery(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            T t = resultHandler.apply(resultSet, this.jdbcContext.dialect());
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T query(SQL sql, ResultHandler<T> resultHandler) throws SQLRunnerException {
        try {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.query(connection, sql, resultHandler);
            }
            try (Connection con = this.getConnection();){
                T t = this.query(con, sql, resultHandler);
                return t;
            }
        }
        catch (SQLException sqlException) {
            throw new SQLRunnerException(sqlException);
        }
    }

    public long execute(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            preparedStatement.execute();
            long l = preparedStatement.getLargeUpdateCount();
            return l;
        }
    }

    public long execute(SQL sql) throws SQLRunnerException {
        long l;
        block9: {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.execute(connection, sql);
            }
            Connection con = this.getConnection();
            try {
                l = this.execute(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return l;
    }

    public UpdateResult update(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            long affectedItemsCount = preparedStatement.executeLargeUpdate();
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public UpdateResult update(SQL sql) throws SQLRunnerException {
        UpdateResult updateResult;
        block9: {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.update(connection, sql);
            }
            Connection con = this.getConnection();
            try {
                updateResult = this.update(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return updateResult;
    }

    public UpdateResult updateBatch(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            long[] counts = preparedStatement.executeLargeBatch();
            long affectedItemsCount = 0L;
            for (long count : counts) {
                affectedItemsCount += count;
            }
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public UpdateResult updateBatch(SQL sql) throws SQLRunnerException {
        UpdateResult updateResult;
        block9: {
            Connection connection = (Connection)CONNECTION_THREAD_LOCAL.get();
            if (connection != null) {
                return this.updateBatch(connection, sql);
            }
            Connection con = this.getConnection();
            try {
                updateResult = this.updateBatch(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return updateResult;
    }

    public <E extends Throwable> void autoTransaction(ScxRunnable<E> handler) throws E, SQLRunnerException {
        this.autoTransaction(() -> {
            handler.run();
            return null;
        });
    }

    public <T, E extends Throwable> T autoTransaction(ScxCallable<T, E> handler) throws E, SQLRunnerException {
        CompletableFuture promise = new CompletableFuture();
        Thread.ofVirtual().name("scx-auto-transaction-thread-", this.threadNumber.getAndIncrement()).start(() -> {
            try {
                Connection con;
                try {
                    con = this.getConnection(false);
                }
                catch (SQLException e) {
                    throw new SQLRunnerException("Failed to acquire connection", e);
                }
                try (Connection twrVar0$ = con;){
                    Object result;
                    CONNECTION_THREAD_LOCAL.set(con);
                    try {
                        result = handler.call();
                    }
                    catch (Throwable handlerE) {
                        try {
                            con.rollback();
                        }
                        catch (SQLException rollbackE) {
                            rollbackE.addSuppressed(handlerE);
                            throw new SQLRunnerException("Rollback failed after business exception", rollbackE);
                        }
                        throw handlerE;
                    }
                    try {
                        con.commit();
                    }
                    catch (SQLException commitE) {
                        try {
                            con.rollback();
                        }
                        catch (SQLException rollbackE) {
                            rollbackE.addSuppressed(commitE);
                            throw new SQLRunnerException("Rollback failed after commit failure", rollbackE);
                        }
                        throw new SQLRunnerException("Commit failed", commitE);
                    }
                    promise.complete(result);
                }
                finally {
                    CONNECTION_THREAD_LOCAL.remove();
                }
            }
            catch (Throwable e) {
                promise.completeExceptionally(e);
            }
        });
        try {
            return promise.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Transaction thread was interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLRunnerException) {
                SQLRunnerException transactionException = (SQLRunnerException)cause;
                throw transactionException;
            }
            throw cause;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = this.jdbcContext.dataSource().getConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }
}

