/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler;

import cool.scx.functional.ScxConsumer;
import cool.scx.jdbc.dialect.DefaultDialect;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.BeanConsumerHandler;
import cool.scx.jdbc.result_handler.BeanHandler;
import cool.scx.jdbc.result_handler.BeanListHandler;
import cool.scx.jdbc.result_handler.MapConsumerHandler;
import cool.scx.jdbc.result_handler.MapHandler;
import cool.scx.jdbc.result_handler.MapListHandler;
import cool.scx.jdbc.result_handler.SingleValueHandler;
import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.map_builder.MapBuilder;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ResultHandler<T, E extends Throwable> {
    public static ResultHandler<Map<String, Object>, RuntimeException> ofMap() {
        return MapHandler.INSTANCE;
    }

    public static ResultHandler<Map<String, Object>, RuntimeException> ofMap(MapBuilder mapBuilder) {
        return new MapHandler(mapBuilder);
    }

    public static ResultHandler<Map<String, Object>, RuntimeException> ofMap(Supplier<Map<String, Object>> mapSupplier) {
        return new MapHandler(MapBuilder.of(mapSupplier));
    }

    public static ResultHandler<Map<String, Object>, RuntimeException> ofMap(Function<String, String> fieldNameMapping) {
        return new MapHandler(MapBuilder.of(fieldNameMapping));
    }

    public static ResultHandler<List<Map<String, Object>>, RuntimeException> ofMapList() {
        return MapListHandler.INSTANCE;
    }

    public static ResultHandler<List<Map<String, Object>>, RuntimeException> ofMapList(MapBuilder mapBuilder) {
        return new MapListHandler(mapBuilder);
    }

    public static ResultHandler<List<Map<String, Object>>, RuntimeException> ofMapList(Supplier<Map<String, Object>> mapSupplier) {
        return new MapListHandler(MapBuilder.of(mapSupplier));
    }

    public static ResultHandler<List<Map<String, Object>>, RuntimeException> ofMapList(Function<String, String> fieldNameMapping) {
        return new MapListHandler(MapBuilder.of(fieldNameMapping));
    }

    public static <C> ResultHandler<C, RuntimeException> ofBean(Class<C> clazz) {
        return new BeanHandler<C>(BeanBuilder.of(clazz));
    }

    public static <C> ResultHandler<C, RuntimeException> ofBean(Class<C> clazz, Function<Field, String> columnNameMapping) {
        return new BeanHandler<C>(BeanBuilder.of(clazz, columnNameMapping));
    }

    public static <C> ResultHandler<C, RuntimeException> ofBean(BeanBuilder<C> beanBuilder) {
        return new BeanHandler<C>(beanBuilder);
    }

    public static <C> ResultHandler<List<C>, RuntimeException> ofBeanList(Class<C> clazz) {
        return new BeanListHandler<C>(BeanBuilder.of(clazz));
    }

    public static <C> ResultHandler<List<C>, RuntimeException> ofBeanList(Class<C> clazz, Function<Field, String> columnNameMapping) {
        return new BeanListHandler<C>(BeanBuilder.of(clazz, columnNameMapping));
    }

    public static <C> ResultHandler<List<C>, RuntimeException> ofBeanList(BeanBuilder<C> beanBuilder) {
        return new BeanListHandler<C>(beanBuilder);
    }

    public static <C, E extends Throwable> ResultHandler<Void, E> ofBeanConsumer(Class<C> clazz, ScxConsumer<C, E> consumer) {
        return new BeanConsumerHandler<C, E>(BeanBuilder.of(clazz), consumer);
    }

    public static <C, E extends Throwable> ResultHandler<Void, E> ofBeanConsumer(Class<C> clazz, Function<Field, String> columnNameMapping, ScxConsumer<C, E> consumer) {
        return new BeanConsumerHandler<C, E>(BeanBuilder.of(clazz, columnNameMapping), consumer);
    }

    public static <C, E extends Throwable> ResultHandler<Void, E> ofBeanConsumer(BeanBuilder<C> beanBuilder, ScxConsumer<C, E> consumer) {
        return new BeanConsumerHandler<C, E>(beanBuilder, consumer);
    }

    public static <E extends Throwable> ResultHandler<Void, E> ofMapConsumer(ScxConsumer<Map<String, Object>, E> consumer) {
        return new MapConsumerHandler<E>(MapBuilder.of(), consumer);
    }

    public static <E extends Throwable> ResultHandler<Void, E> ofMapConsumer(MapBuilder mapBuilder, ScxConsumer<Map<String, Object>, E> consumer) {
        return new MapConsumerHandler<E>(mapBuilder, consumer);
    }

    public static <E extends Throwable> ResultHandler<Void, E> ofMapConsumer(Supplier<Map<String, Object>> mapSupplier, ScxConsumer<Map<String, Object>, E> consumer) {
        return new MapConsumerHandler<E>(MapBuilder.of(mapSupplier), consumer);
    }

    public static <E extends Throwable> ResultHandler<Void, E> ofMapConsumer(Function<String, String> fieldNameMapping, ScxConsumer<Map<String, Object>, E> consumer) {
        return new MapConsumerHandler<E>(MapBuilder.of(fieldNameMapping), consumer);
    }

    public static <C> ResultHandler<C, RuntimeException> ofSingleValue(String columnName, Class<C> clazz) {
        return new SingleValueHandler<C>(columnName, clazz);
    }

    public static <C> ResultHandler<C, RuntimeException> ofSingleValue(int columnIndex, Class<C> clazz) {
        return new SingleValueHandler<C>(columnIndex, clazz);
    }

    public T apply(ResultSet var1, Dialect var2) throws SQLException, E;

    default public T apply(ResultSet rs) throws SQLException, E {
        return this.apply(rs, DefaultDialect.DEFAULT_DIALECT);
    }
}

