/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc;

import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Column;
import cool.scx.jdbc.mapping.Table;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import cool.scx.jdbc.meta_data.TableMetaData;
import cool.scx.jdbc.sql.SQL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;

public final class SchemaHelper {
    public static String getMigrateSQL(Table oldTable, Table newTable, Dialect dialect) {
        TableVerifyResult verifyResult = SchemaHelper.verifyTable(oldTable, newTable);
        if (verifyResult.notEmpty()) {
            return dialect.getAlterTableDDL(verifyResult.needAdd(), new Column[0], verifyResult.needChange(), newTable);
        }
        return null;
    }

    public static ColumnVerifyResult verifyColumn(Column oldColumn, Column newColumn) {
        boolean needChangeDataType = false;
        boolean needChangeIndex = false;
        boolean needChangeDefaultValue = false;
        if (oldColumn.dataType().jdbcType() != newColumn.dataType().jdbcType()) {
            needChangeDataType = true;
        }
        if (!oldColumn.index() && newColumn.index()) {
            needChangeIndex = true;
        }
        if (oldColumn.defaultValue() == null && newColumn.defaultValue() != null) {
            needChangeDefaultValue = true;
        }
        return new ColumnVerifyResult(needChangeDataType, needChangeIndex, needChangeDefaultValue);
    }

    public static TableVerifyResult verifyTable(Table oldTable, Table newTable) {
        ArrayList<Column> needAdd = new ArrayList<Column>();
        ArrayList<Column> needRemove = new ArrayList<Column>();
        ArrayList<NeedChangeColumn> needChange = new ArrayList<NeedChangeColumn>();
        for (Column oldColumn : oldTable.columns()) {
            Column newColumn = newTable.getColumn(oldColumn.name());
            if (newColumn == null) {
                needRemove.add(oldColumn);
                continue;
            }
            ColumnVerifyResult columnVerifyResult = SchemaHelper.verifyColumn(oldColumn, newColumn);
            if (!columnVerifyResult.notEmpty()) continue;
            needChange.add(new NeedChangeColumn(oldColumn, newColumn, columnVerifyResult));
        }
        for (Column newColumn : newTable.columns()) {
            Column oldColumn = oldTable.getColumn(newColumn.name());
            if (oldColumn != null) continue;
            needAdd.add(newColumn);
        }
        return new TableVerifyResult((Column[])needAdd.toArray(Column[]::new), (Column[])needRemove.toArray(Column[]::new), (NeedChangeColumn[])needChange.toArray(NeedChangeColumn[]::new));
    }

    public static void fixTable(Table tableInfo, JDBCContext jdbcContext) throws SQLException {
        try (Connection con = jdbcContext.dataSource().getConnection();){
            TableMetaData tableMetaData = MetaDataHelper.getCurrentSchema(con).getTable(con, tableInfo.name());
            if (tableMetaData == null) {
                String createTableDDL = jdbcContext.dialect().getCreateTableDDL(tableInfo);
                jdbcContext.sqlRunner().execute(con, SQL.sql(createTableDDL, new Object[0]));
                return;
            }
            String migrateSQL = SchemaHelper.getMigrateSQL(tableMetaData.refreshColumns(con, jdbcContext.dialect()), tableInfo, jdbcContext.dialect());
            if (migrateSQL != null) {
                jdbcContext.sqlRunner().execute(con, SQL.sql(migrateSQL, new Object[0]));
            }
        }
    }

    public static boolean checkNeedFixTable(Table tableInfo, JDBCContext jdbcContext) throws SQLException {
        try (Connection con = jdbcContext.dataSource().getConnection();){
            TableMetaData tableMetaData = MetaDataHelper.getCurrentSchema(con).getTable(con, tableInfo.name());
            if (tableMetaData == null) {
                boolean bl = true;
                return bl;
            }
            TableVerifyResult tableVerifyResult = SchemaHelper.verifyTable(tableMetaData.refreshColumns(con, jdbcContext.dialect()), tableInfo);
            boolean bl = tableVerifyResult.notEmpty();
            return bl;
        }
    }

    public record TableVerifyResult(Column[] needAdd, Column[] needRemove, NeedChangeColumn[] needChange) {
        public boolean notEmpty() {
            return this.needAdd.length > 0 || this.needRemove.length > 0 || this.needChange.length > 0;
        }
    }

    public record NeedChangeColumn(Column oldColumn, Column newColumn, ColumnVerifyResult verifyResult) {
    }

    public record ColumnVerifyResult(boolean needChangeDataType, boolean needChangeIndex, boolean needChangeDefaultValue) {
        public boolean notEmpty() {
            return this.needChangeDataType || this.needChangeIndex || this.needChangeDefaultValue;
        }
    }
}

