/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.result_handler.bean_builder;

import cool.scx.jdbc.result_handler.bean_builder.BeanBuilder;
import cool.scx.jdbc.result_handler.bean_builder.FieldSetter;
import cool.scx.reflect.ClassInfo;
import cool.scx.reflect.ConstructorInfo;
import cool.scx.reflect.ParameterInfo;
import cool.scx.reflect.ScxReflect;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.function.Function;

final class RecordBeanBuilder<T>
extends BeanBuilder<T> {
    private final ConstructorInfo constructor;
    private final FieldSetter[] fieldSetters;

    public RecordBeanBuilder(Class<T> type, Function<Field, String> columnNameMapping) {
        this.constructor = RecordBeanBuilder.checkRecordConstructor((ClassInfo)ScxReflect.typeOf(type));
        this.constructor.setAccessible(true);
        this.fieldSetters = RecordBeanBuilder.sortFieldSetters(this.constructor.parameters(), FieldSetter.ofArray(type, columnNameMapping));
    }

    public RecordBeanBuilder(Class<T> type) {
        this(type, Field::getName);
    }

    private static FieldSetter[] sortFieldSetters(ParameterInfo[] parameters, FieldSetter[] fieldSetters) {
        HashMap<String, FieldSetter> map = new HashMap<String, FieldSetter>();
        for (FieldSetter fieldSetter : fieldSetters) {
            map.put(fieldSetter.fieldInfo().name(), fieldSetter);
        }
        FieldSetter[] temp = new FieldSetter[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            temp[i] = (FieldSetter)map.get(parameters[i].name());
        }
        return temp;
    }

    public static ConstructorInfo checkRecordConstructor(ClassInfo type) {
        ConstructorInfo canonicalConstructor = type.recordConstructor();
        if (canonicalConstructor == null) {
            throw new IllegalArgumentException("\u5bfb\u627e Record \u89c4\u8303\u6784\u9020\u51fd\u6570\u5931\u8d25, type " + type.name());
        }
        return canonicalConstructor;
    }

    @Override
    public T createBean(ResultSet rs, int[] indexInfo) throws SQLException {
        Object[] objs = new Object[this.fieldSetters.length];
        for (int i = 0; i < this.fieldSetters.length; ++i) {
            objs[i] = indexInfo[i] != -1 ? this.fieldSetters[i].typeHandler().getObject(rs, indexInfo[i]) : this.fieldSetters[i].typeHandler().getDefaultValue();
        }
        return this.newInstance(objs);
    }

    @Override
    public FieldSetter[] fieldSetters() {
        return this.fieldSetters;
    }

    private T newInstance(Object ... objs) {
        try {
            return (T)this.constructor.newInstance(objs);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

