/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.type_handler;

import cool.scx.jdbc.type_handler.TypeHandler;
import cool.scx.object.ScxObject;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.parser.NodeParseException;
import cool.scx.object.serializer.NodeSerializeException;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ObjectTypeHandler
implements TypeHandler<Object> {
    private static final System.Logger logger = System.getLogger(ObjectTypeHandler.class.getName());
    private final TypeInfo javaType;

    public ObjectTypeHandler(Type type) {
        this.javaType = ScxReflect.typeOf((Type)type);
    }

    public ObjectTypeHandler(TypeInfo type) {
        this.javaType = type;
    }

    @Override
    public void setObject(PreparedStatement ps, int i, Object parameter) throws SQLException {
        try {
            String json = ScxObject.toJson((Object)parameter);
            ps.setString(i, json);
        }
        catch (NodeMappingException | NodeSerializeException e) {
            logger.log(System.Logger.Level.ERROR, "\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", e);
            ps.setNull(i, 0);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        String json = rs.getString(index);
        if (json == null) {
            return null;
        }
        try {
            return ScxObject.fromJson((String)json, (TypeInfo)this.javaType);
        }
        catch (NodeMappingException | NodeParseException e) {
            logger.log(System.Logger.Level.ERROR, "\u53cd\u5e8f\u5217\u5316\u65f6\u53d1\u751f\u9519\u8bef , \u5df2\u4f7f\u7528 NULL !!!", e);
            return null;
        }
    }
}

