/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.meta_data;

import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.mapping.Catalog;
import cool.scx.jdbc.meta_data.MetaDataHelper;
import cool.scx.jdbc.meta_data.SchemaMetaData;
import java.sql.Connection;
import java.sql.SQLException;

public final class CatalogMetaData
implements Catalog {
    private final String name;
    private SchemaMetaData[] schemas;

    public CatalogMetaData(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    public SchemaMetaData[] schemas() {
        return this.schemas;
    }

    public CatalogMetaData refreshSchemas(Connection connection) throws SQLException {
        this.schemas = MetaDataHelper.getSchemas(connection, this.name, null);
        return this;
    }

    public CatalogMetaData refreshSchemasDeep(Connection connection, Dialect dialect) throws SQLException {
        this.refreshSchemas(connection);
        for (SchemaMetaData schema : this.schemas) {
            schema.refreshTablesDeep(connection, dialect);
        }
        return this;
    }
}

