/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.jdbc.sql;

import cool.scx.common.scope_value.ScxScopedValue;
import cool.scx.function.CallableX;
import cool.scx.function.ConsumerX;
import cool.scx.function.FunctionX;
import cool.scx.function.RunnableX;
import cool.scx.jdbc.JDBCContext;
import cool.scx.jdbc.dialect.Dialect;
import cool.scx.jdbc.result_handler.ResultHandler;
import cool.scx.jdbc.sql.SQL;
import cool.scx.jdbc.sql.SQLRunnerException;
import cool.scx.jdbc.sql.UpdateResult;
import cool.scx.jdbc.type_handler.TypeHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class SQLRunner {
    private static final ScxScopedValue<Connection> CONNECTION_SCOPE_VALUE = ScxScopedValue.newInstance();
    private static final ScxScopedValue<SQLRunner> SQL_RUNNER_SCOPE_VALUE = ScxScopedValue.newInstance();
    private final JDBCContext jdbcContext;

    public SQLRunner(JDBCContext jdbcContext) {
        this.jdbcContext = jdbcContext;
    }

    private static List<Long> getGeneratedKeys(PreparedStatement preparedStatement) throws SQLException {
        try (ResultSet resultSet = preparedStatement.getGeneratedKeys();){
            ArrayList<Long> ids = new ArrayList<Long>();
            while (resultSet.next()) {
                ids.add(resultSet.getLong(1));
            }
            ArrayList<Long> arrayList = ids;
            return arrayList;
        }
    }

    private static PreparedStatement fillParams(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        return sql.isBatch() ? SQLRunner.fillBatch(sql, preparedStatement, typeHandlerSelector) : SQLRunner.fillSingle(sql, preparedStatement, typeHandlerSelector);
    }

    private static PreparedStatement fillSingle(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.params() != null) {
            SQLRunner.fillPreparedStatement(preparedStatement, sql.params(), typeHandlerSelector);
        }
        return preparedStatement;
    }

    private static PreparedStatement fillBatch(SQL sql, PreparedStatement preparedStatement, Dialect typeHandlerSelector) throws SQLException {
        if (sql.batchParams() != null) {
            for (Object[] paramArray : sql.batchParams()) {
                if (paramArray == null) continue;
                SQLRunner.fillPreparedStatement(preparedStatement, paramArray, typeHandlerSelector);
                preparedStatement.addBatch();
            }
        }
        return preparedStatement;
    }

    private static void fillPreparedStatement(PreparedStatement preparedStatement, Object[] params, Dialect dialect) throws SQLException {
        int index = 1;
        for (Object tempValue : params) {
            if (tempValue == null) {
                preparedStatement.setNull(index, 0);
            } else {
                TypeHandler<Object> typeHandler = dialect.findTypeHandler(tempValue.getClass());
                typeHandler.setObject(preparedStatement, index, tempValue);
            }
            ++index;
        }
    }

    private Connection getConnection() throws SQLException {
        return this.getConnection(true);
    }

    private Connection getConnection(boolean autoCommit) throws SQLException {
        Connection con = this.jdbcContext.dataSource().getConnection();
        con.setAutoCommit(autoCommit);
        return con;
    }

    public <T, X extends Throwable> T query(Connection con, SQL sql, ResultHandler<T, X> resultHandler) throws SQLException, X {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1003, 1007);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            this.jdbcContext.dialect().beforeExecuteQuery(preparedStatement);
            ResultSet resultSet = preparedStatement.executeQuery();
            T t = resultHandler.apply(resultSet, this.jdbcContext.dialect());
            return t;
        }
    }

    public long execute(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            preparedStatement.execute();
            long l = preparedStatement.getLargeUpdateCount();
            return l;
        }
    }

    public UpdateResult update(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            long affectedItemsCount = preparedStatement.executeLargeUpdate();
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    public UpdateResult updateBatch(Connection con, SQL sql) throws SQLException {
        try (PreparedStatement preparedStatement = con.prepareStatement(sql.sql(), 1);){
            SQLRunner.fillParams(sql, preparedStatement, this.jdbcContext.dialect());
            long[] counts = preparedStatement.executeLargeBatch();
            long affectedItemsCount = 0L;
            for (long count : counts) {
                affectedItemsCount += count;
            }
            List<Long> generatedKeys = SQLRunner.getGeneratedKeys(preparedStatement);
            UpdateResult updateResult = new UpdateResult(affectedItemsCount, generatedKeys);
            return updateResult;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, X extends Throwable> T query(SQL sql, ResultHandler<T, X> resultHandler) throws SQLRunnerException, X {
        try {
            if (CONNECTION_SCOPE_VALUE.isBound()) {
                Connection connection = (Connection)CONNECTION_SCOPE_VALUE.get();
                return this.query(connection, sql, resultHandler);
            }
            SQLRunner sqlRunner = SQL_RUNNER_SCOPE_VALUE.isBound() ? (SQLRunner)SQL_RUNNER_SCOPE_VALUE.get() : this;
            try (Connection con = sqlRunner.getConnection();){
                T t = this.query(con, sql, resultHandler);
                return t;
            }
        }
        catch (SQLException sqlException) {
            throw new SQLRunnerException(sqlException);
        }
    }

    public long execute(SQL sql) throws SQLRunnerException {
        long l;
        block9: {
            if (CONNECTION_SCOPE_VALUE.isBound()) {
                Connection connection = (Connection)CONNECTION_SCOPE_VALUE.get();
                return this.execute(connection, sql);
            }
            SQLRunner sqlRunner = SQL_RUNNER_SCOPE_VALUE.isBound() ? (SQLRunner)SQL_RUNNER_SCOPE_VALUE.get() : this;
            Connection con = sqlRunner.getConnection();
            try {
                l = this.execute(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return l;
    }

    public UpdateResult update(SQL sql) throws SQLRunnerException {
        UpdateResult updateResult;
        block9: {
            if (CONNECTION_SCOPE_VALUE.isBound()) {
                Connection connection = (Connection)CONNECTION_SCOPE_VALUE.get();
                return this.update(connection, sql);
            }
            SQLRunner sqlRunner = SQL_RUNNER_SCOPE_VALUE.isBound() ? (SQLRunner)SQL_RUNNER_SCOPE_VALUE.get() : this;
            Connection con = sqlRunner.getConnection();
            try {
                updateResult = this.update(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return updateResult;
    }

    public UpdateResult updateBatch(SQL sql) throws SQLRunnerException {
        UpdateResult updateResult;
        block9: {
            if (CONNECTION_SCOPE_VALUE.isBound()) {
                Connection connection = (Connection)CONNECTION_SCOPE_VALUE.get();
                return this.updateBatch(connection, sql);
            }
            SQLRunner sqlRunner = SQL_RUNNER_SCOPE_VALUE.isBound() ? (SQLRunner)SQL_RUNNER_SCOPE_VALUE.get() : this;
            Connection con = sqlRunner.getConnection();
            try {
                updateResult = this.updateBatch(con, sql);
                if (con == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException sqlException) {
                    throw new SQLRunnerException(sqlException);
                }
            }
            con.close();
        }
        return updateResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, X extends Throwable> T autoTransaction(CallableX<T, X> handler) throws X, SQLRunnerException {
        try (Connection con = this.getConnection(false);){
            Object object = ScxScopedValue.where(CONNECTION_SCOPE_VALUE, (Object)con).call(() -> {
                Object result;
                try {
                    result = handler.call();
                }
                catch (Throwable handlerE) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException rollbackE) {
                        rollbackE.addSuppressed(handlerE);
                        throw new SQLRunnerException("Rollback failed after business exception", rollbackE);
                    }
                    throw handlerE;
                }
                try {
                    con.commit();
                }
                catch (SQLException commitE) {
                    try {
                        con.rollback();
                    }
                    catch (SQLException rollbackE) {
                        rollbackE.addSuppressed(commitE);
                        throw new SQLRunnerException("Rollback failed after commit failure", rollbackE);
                    }
                    throw new SQLRunnerException("Commit failed", commitE);
                }
                return result;
            });
            return (T)object;
        }
        catch (SQLException e) {
            throw new SQLRunnerException(e);
        }
    }

    public <X extends Throwable> void autoTransaction(RunnableX<X> handler) throws X, SQLRunnerException {
        this.autoTransaction(() -> {
            handler.run();
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T, X extends Throwable> T withTransaction(FunctionX<Connection, T, X> handler) throws SQLRunnerException, X {
        try (Connection con = this.getConnection(false);){
            Object object = ScxScopedValue.where(CONNECTION_SCOPE_VALUE, (Object)con).call(() -> handler.apply((Object)con));
            return (T)object;
        }
        catch (SQLException e) {
            throw new SQLRunnerException(e);
        }
    }

    public <X extends Throwable> void withTransaction(ConsumerX<Connection, X> handler) throws SQLRunnerException, X {
        this.withTransaction(con -> {
            handler.accept(con);
            return null;
        });
    }

    public <T, X extends Throwable> T autoContext(CallableX<T, X> handler) throws SQLRunnerException, X {
        return (T)ScxScopedValue.where(SQL_RUNNER_SCOPE_VALUE, (Object)this).call(handler);
    }

    public <X extends Throwable> void autoContext(RunnableX<X> handler) throws SQLRunnerException, X {
        this.autoContext(() -> {
            handler.run();
            return null;
        });
    }
}

