/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLoggerHelper;
import cool.scx.logging.ScxLoggingLevel;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;

final class ScxLoggerMessage
extends StringWriter {
    private final String logFileName;

    public ScxLoggerMessage(LocalDateTime now, ScxLoggingLevel level, String name, String msg) {
        String nowTimeStr = ScxLoggerHelper.getTimeStamp(now);
        String currentThreadName = Thread.currentThread().getName();
        String levelStr = level.toFixedLengthString();
        this.logFileName = nowTimeStr.substring(0, 10) + ".log";
        this.append(nowTimeStr).append(" [").append(currentThreadName).append("] ").append(levelStr).append(" ").append(name).append(" - ").append(msg).append(System.lineSeparator());
    }

    public void appendThrowable(Throwable throwable) {
        throwable.printStackTrace(new PrintWriter(this));
    }

    public void appendStackTraceInfo(Exception e) {
        StackTraceElement[] trace;
        for (StackTraceElement traceElement : trace = e.getStackTrace()) {
            if (!ScxLoggerHelper.isLoggerClass(traceElement.getClassName())) continue;
            this.append("\t").append(traceElement.toString()).append(System.lineSeparator());
        }
    }

    public void writeToFile(Path logStoredPath) {
        try {
            Path path = Path.of(logStoredPath.toString(), this.logFileName);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)this.getBuffer().toString(), StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeToConsole(ScxLoggingLevel level) {
        if (level.toInt() <= ScxLoggingLevel.ERROR.toInt()) {
            System.err.print(this.getBuffer().toString());
        } else {
            System.out.print(this.getBuffer().toString());
        }
    }
}

