/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public final class ScxLoggerFactory {
    private static final Map<String, ScxLogger> LOGGER_CACHE = new HashMap<String, ScxLogger>();
    private static ScxLoggingLevel defaultLevel = ScxLoggingLevel.ERROR;
    private static ScxLoggingType defaultType = ScxLoggingType.CONSOLE;
    private static Path defaultStoredDirectory = null;
    private static Boolean defaultStackTrace = false;

    static ScxLoggingLevel defaultLevel() {
        return defaultLevel;
    }

    static ScxLoggingType defaultType() {
        return defaultType;
    }

    static Path defaultStoredDirectory() {
        return defaultStoredDirectory;
    }

    static Boolean defaultStackTrace() {
        return defaultStackTrace;
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    public static ScxLogger getLogger(String name) {
        ScxLogger logger = LOGGER_CACHE.get(name);
        if (logger == null) {
            ScxLogger scxLogger = new ScxLogger(name);
            LOGGER_CACHE.put(name, scxLogger);
            logger = scxLogger;
        }
        return logger;
    }

    public static void updateLogger(String name, ScxLoggingLevel level, ScxLoggingType type, Path storedDirectory, Boolean stackTrace) {
        ScxLoggerFactory.getLogger(name).update(level, type, storedDirectory, stackTrace);
    }

    public static void updateLogger(Class<?> clazz, ScxLoggingLevel level, ScxLoggingType type, Path storedDirectory, Boolean stackTrace) {
        ScxLoggerFactory.getLogger(clazz).update(level, type, storedDirectory, stackTrace);
    }

    public static void updateDefault(ScxLoggingLevel newDefaultLevel, ScxLoggingType newDefaultType, Path newDefaultStoredDirectory, Boolean newDefaultStackTrace) {
        defaultLevel = newDefaultLevel;
        defaultType = newDefaultType;
        defaultStoredDirectory = newDefaultStoredDirectory;
        defaultStackTrace = newDefaultStackTrace;
    }
}

