/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

final class ScxLoggerHelper {
    private static final DateTimeFormatter LOG_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    ScxLoggerHelper() {
    }

    public static String getTimeStamp(LocalDateTime time) {
        return LOG_DATETIME_FORMATTER.format(time);
    }

    public static boolean needWriteToConsole(ScxLoggingType type) {
        return type == ScxLoggingType.CONSOLE || type == ScxLoggingType.BOTH;
    }

    public static boolean needWriteToFile(ScxLoggingType type) {
        return type == ScxLoggingType.FILE || type == ScxLoggingType.BOTH;
    }

    public static boolean dontNeedLog(ScxLoggingLevel level) {
        return level == ScxLoggingLevel.OFF;
    }

    public static boolean isLoggerClass(String className) {
        return !className.startsWith("cool.scx.logging") && !className.startsWith("org.slf4j.helpers") && !className.startsWith("org.apache.logging.log4j");
    }
}

