/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import java.util.Objects;

public enum ScxLoggingLevel {
    OFF(0, "OFF"),
    FATAL(10, "FATAL"),
    ERROR(20, "ERROR"),
    WARN(30, "WARN"),
    INFO(40, "INFO"),
    DEBUG(50, "DEBUG"),
    TRACE(60, "TRACE"),
    ALL(70, "ALL");

    private final int levelInt;
    private final String levelStr;
    private final String fixedLengthStr;

    private ScxLoggingLevel(int i, String s) {
        this.levelInt = i;
        this.levelStr = s;
        this.fixedLengthStr = (this.levelStr + "  ").substring(0, 5);
    }

    public static ScxLoggingLevel of(String levelName) {
        Objects.requireNonNull(levelName, "levelName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return ScxLoggingLevel.valueOf(levelName.trim().toUpperCase());
    }

    public static ScxLoggingLevel of(String levelName, ScxLoggingLevel defaultLevel) {
        try {
            return ScxLoggingLevel.of(levelName);
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }

    public int toInt() {
        return this.levelInt;
    }

    public String toFixedLengthString() {
        return this.fixedLengthStr;
    }

    public String toString() {
        return this.levelStr;
    }
}

