/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.slf4j;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggingLevel;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;

public final class ScxSLF4JLogger
extends LegacyAbstractLogger {
    private final ScxLogger scxLogger;

    public ScxSLF4JLogger(String name) {
        this.name = name;
        this.scxLogger = ScxLoggerFactory.getLogger(name);
    }

    private static ScxLoggingLevel toScxLoggingLevel(Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case Level.ERROR -> ScxLoggingLevel.ERROR;
            case Level.WARN -> ScxLoggingLevel.WARN;
            case Level.INFO -> ScxLoggingLevel.INFO;
            case Level.DEBUG -> ScxLoggingLevel.DEBUG;
            case Level.TRACE -> ScxLoggingLevel.TRACE;
        };
    }

    private static Level toSLF4JLevel(ScxLoggingLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ScxLoggingLevel.OFF, ScxLoggingLevel.FATAL, ScxLoggingLevel.ERROR -> Level.ERROR;
            case ScxLoggingLevel.WARN -> Level.WARN;
            case ScxLoggingLevel.INFO -> Level.INFO;
            case ScxLoggingLevel.DEBUG -> Level.DEBUG;
            case ScxLoggingLevel.TRACE, ScxLoggingLevel.ALL -> Level.TRACE;
        };
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String message, Object[] arguments, Throwable throwable) {
        this.scxLogger.logMessage(ScxSLF4JLogger.toScxLoggingLevel(level), MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), throwable);
    }

    public boolean isTraceEnabled() {
        return this.getLevel().toInt() <= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.getLevel().toInt() <= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.getLevel().toInt() <= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.getLevel().toInt() <= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.getLevel().toInt() <= Level.ERROR.toInt();
    }

    public Level getLevel() {
        return ScxSLF4JLogger.toSLF4JLevel(this.scxLogger.level());
    }
}

