/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggerHelper;
import cool.scx.logging.ScxLoggerMessage;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.nio.file.Path;
import java.time.LocalDateTime;

public final class ScxLogger {
    private final String name;
    private ScxLoggingLevel level = null;
    private ScxLoggingType type = null;
    private Path storedDirectory = null;
    private Boolean stackTrace = null;

    ScxLogger(String name) {
        this.name = name;
    }

    public ScxLoggingLevel level() {
        return this.level != null ? this.level : ScxLoggerFactory.defaultLevel();
    }

    private ScxLoggingType type() {
        return this.type != null ? this.type : ScxLoggerFactory.defaultType();
    }

    private Path storedDirectory() {
        return this.storedDirectory != null ? this.storedDirectory : ScxLoggerFactory.defaultStoredDirectory();
    }

    private boolean stackTrace() {
        return this.stackTrace != null ? this.stackTrace : ScxLoggerFactory.defaultStackTrace();
    }

    public void logMessage(ScxLoggingLevel level, String msg, Throwable throwable) {
        if (ScxLoggerHelper.dontNeedLog(level)) {
            return;
        }
        ScxLoggerMessage message = new ScxLoggerMessage(LocalDateTime.now(), level, this.name, msg);
        if (throwable != null) {
            message.appendThrowable(throwable);
        } else if (this.stackTrace()) {
            message.appendStackTraceInfo(new Exception());
        }
        ScxLoggingType t = this.type();
        if (ScxLoggerHelper.needWriteToConsole(t)) {
            message.writeToConsole(level);
        }
        if (ScxLoggerHelper.needWriteToFile(t)) {
            message.writeToFile(this.storedDirectory());
        }
    }

    ScxLogger setLevel(ScxLoggingLevel newLevel) {
        this.level = newLevel;
        return this;
    }

    ScxLogger setType(ScxLoggingType newType) {
        this.type = newType;
        return this;
    }

    ScxLogger setStoredDirectory(Path newStoredDirectory) {
        this.storedDirectory = newStoredDirectory;
        return this;
    }

    ScxLogger setStackTrace(Boolean newStackTrace) {
        this.stackTrace = newStackTrace;
        return this;
    }
}

