/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class ScxLoggerFactory {
    private static final Map<String, ScxLogger> LOGGER_MAP = new HashMap<String, ScxLogger>();
    private static ScxLoggingLevel defaultLevel = ScxLoggingLevel.ERROR;
    private static ScxLoggingType defaultType = ScxLoggingType.CONSOLE;
    private static Path defaultStoredDirectory = null;
    private static boolean defaultStackTrace = false;

    static ScxLoggingLevel defaultLevel() {
        return defaultLevel;
    }

    static ScxLoggingType defaultType() {
        return defaultType;
    }

    static Path defaultStoredDirectory() {
        return defaultStoredDirectory;
    }

    static boolean defaultStackTrace() {
        return defaultStackTrace;
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    public static ScxLogger getLogger(String name) {
        return LOGGER_MAP.computeIfAbsent(name, ScxLogger::new);
    }

    public static void setDefaultLevel(ScxLoggingLevel newLevel) {
        Objects.requireNonNull(newLevel, "defaultLevel \u4e0d\u80fd\u4e3a null");
        defaultLevel = newLevel;
    }

    public static void setDefaultType(ScxLoggingType newType) {
        Objects.requireNonNull(newType, "defaultType \u4e0d\u80fd\u4e3a null");
        defaultType = newType;
    }

    public static void setDefaultStoredDirectory(Path newStoredDirectory) {
        defaultStoredDirectory = newStoredDirectory;
    }

    public static void setDefaultStackTrace(boolean newStackTrace) {
        defaultStackTrace = newStackTrace;
    }

    public static void setLevel(String name, ScxLoggingLevel newLevel) {
        ScxLoggerFactory.getLogger(name).setLevel(newLevel);
    }

    public static void setType(String name, ScxLoggingType newType) {
        ScxLoggerFactory.getLogger(name).setType(newType);
    }

    public static void setStoredDirectory(String name, Path newStoredDirectory) {
        ScxLoggerFactory.getLogger(name).setStoredDirectory(newStoredDirectory);
    }

    public static void setStackTrace(String name, boolean newStackTrace) {
        ScxLoggerFactory.getLogger(name).setStackTrace(newStackTrace);
    }

    public static void setLevel(Class<?> clazz, ScxLoggingLevel newLevel) {
        ScxLoggerFactory.getLogger(clazz).setLevel(newLevel);
    }

    public static void setType(Class<?> clazz, ScxLoggingType newType) {
        ScxLoggerFactory.getLogger(clazz).setType(newType);
    }

    public static void setStoredDirectory(Class<?> clazz, Path newStoredDirectory) {
        ScxLoggerFactory.getLogger(clazz).setStoredDirectory(newStoredDirectory);
    }

    public static void setStackTrace(Class<?> clazz, boolean newStackTrace) {
        ScxLoggerFactory.getLogger(clazz).setStackTrace(newStackTrace);
    }

    public static void updateLogger(String name, ScxLoggingLevel level, ScxLoggingType type, Path storedDirectory, Boolean stackTrace) {
        ScxLoggerFactory.getLogger(name).setLevel(level).setType(type).setStoredDirectory(storedDirectory).setStackTrace(stackTrace);
    }

    public static void updateLogger(Class<?> clazz, ScxLoggingLevel level, ScxLoggingType type, Path storedDirectory, Boolean stackTrace) {
        ScxLoggerFactory.getLogger(clazz).setLevel(level).setType(type).setStoredDirectory(storedDirectory).setStackTrace(stackTrace);
    }

    public static void updateDefault(ScxLoggingLevel newDefaultLevel, ScxLoggingType newDefaultType, Path newDefaultStoredDirectory, boolean newDefaultStackTrace) {
        ScxLoggerFactory.setDefaultLevel(newDefaultLevel);
        ScxLoggerFactory.setDefaultType(newDefaultType);
        ScxLoggerFactory.setDefaultStoredDirectory(newDefaultStoredDirectory);
        ScxLoggerFactory.setDefaultStackTrace(newDefaultStackTrace);
    }
}

