/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggerHelper;
import cool.scx.logging.ScxLoggerMessageFormatter;
import cool.scx.logging.ScxLoggingLevel;
import cool.scx.logging.ScxLoggingType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;

public class ScxLogger {
    private final String name;
    private ScxLoggingLevel level = null;
    private ScxLoggingType type = null;
    private Path storedDirectory = null;
    private Boolean stackTrace = null;
    private ScxLoggerMessageFormatter messageFormatter = null;

    public ScxLogger(String name) {
        this.name = name;
    }

    public void logMessage(ScxLoggingLevel level, String msg, Throwable throwable) {
        if (ScxLoggerHelper.dontNeedLog(level)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        String stackTraceInfo = this.stackTrace() ? ScxLoggerHelper.getStackTraceInfo(new Exception()) : null;
        String message = this.messageFormatter().format(now, level, this.name, msg, throwable, stackTraceInfo);
        ScxLoggingType t = this.type();
        if (ScxLoggerHelper.needWriteToConsole(t)) {
            if (level.toInt() <= ScxLoggingLevel.ERROR.toInt()) {
                System.err.print(message);
            } else {
                System.out.print(message);
            }
        }
        if (ScxLoggerHelper.needWriteToFile(t)) {
            Path directory = this.storedDirectory();
            if (directory == null) {
                return;
            }
            try {
                String logFileName = ScxLoggerHelper.getLogFileName(now);
                Path path = directory.resolve(logFileName);
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)message, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final ScxLogger setLevel(ScxLoggingLevel newLevel) {
        this.level = newLevel;
        return this;
    }

    public final ScxLogger setType(ScxLoggingType newType) {
        this.type = newType;
        return this;
    }

    public final ScxLogger setStoredDirectory(Path newStoredDirectory) {
        this.storedDirectory = newStoredDirectory;
        return this;
    }

    public final ScxLogger setStackTrace(Boolean newStackTrace) {
        this.stackTrace = newStackTrace;
        return this;
    }

    public final ScxLogger setMessageFormatter(ScxLoggerMessageFormatter newMessageFormatter) {
        this.messageFormatter = newMessageFormatter;
        return this;
    }

    public final ScxLoggingLevel level() {
        return this.level != null ? this.level : ScxLoggerFactory.defaultLevel();
    }

    public final ScxLoggingType type() {
        return this.type != null ? this.type : ScxLoggerFactory.defaultType();
    }

    public final Path storedDirectory() {
        return this.storedDirectory != null ? this.storedDirectory : ScxLoggerFactory.defaultStoredDirectory();
    }

    public final boolean stackTrace() {
        return this.stackTrace != null ? this.stackTrace : ScxLoggerFactory.defaultStackTrace();
    }

    public final ScxLoggerMessageFormatter messageFormatter() {
        return this.messageFormatter != null ? this.messageFormatter : ScxLoggerFactory.defaultMessageFormatter();
    }
}

