/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import java.util.Objects;

public enum ScxLoggingLevel {
    OFF(0),
    FATAL(10),
    ERROR(20),
    WARN(30),
    INFO(40),
    DEBUG(50),
    TRACE(60),
    ALL(70);

    private final int levelInt;
    private final String fixedLengthName;

    private ScxLoggingLevel(int i) {
        this.levelInt = i;
        this.fixedLengthName = (this.name() + "  ").substring(0, 5);
    }

    public static ScxLoggingLevel of(String levelName) {
        String s;
        Objects.requireNonNull(levelName, "levelName \u4e0d\u80fd\u4e3a\u7a7a !!!");
        return switch (s = levelName.trim().toUpperCase()) {
            case "OFF", "O" -> OFF;
            case "FATAL", "F" -> FATAL;
            case "ERROR", "E" -> ERROR;
            case "WARN", "W" -> WARN;
            case "INFO", "I" -> INFO;
            case "DEBUG", "D" -> DEBUG;
            case "TRACE", "T" -> TRACE;
            case "ALL", "A" -> ALL;
            default -> throw new IllegalArgumentException("levelName \u503c\u4e0d\u5408\u6cd5 :" + levelName);
        };
    }

    public static ScxLoggingLevel of(String levelName, ScxLoggingLevel defaultLevel) {
        try {
            return ScxLoggingLevel.of(levelName);
        }
        catch (Exception e) {
            return defaultLevel;
        }
    }

    public int toInt() {
        return this.levelInt;
    }

    public String fixedLengthName() {
        return this.fixedLengthName;
    }
}

