/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLoggingLevel;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ScxLoggerConfig {
    private final ScxLoggerConfig parent;
    private ScxLoggingLevel level = null;
    private Boolean stackTrace = null;
    private Set<ScxLogRecorder> recorders = null;

    public ScxLoggerConfig(ScxLoggerConfig parent) {
        this.parent = parent;
    }

    public final ScxLoggingLevel level() {
        return this.level != null ? this.level : (this.parent != null ? this.parent.level() : ScxLoggingLevel.ERROR);
    }

    public final Boolean stackTrace() {
        return this.stackTrace != null ? this.stackTrace : (this.parent != null ? this.parent.stackTrace() : false);
    }

    public final Set<ScxLogRecorder> recorders() {
        return this.recorders != null ? this.recorders : (this.parent != null ? this.parent.recorders() : new HashSet());
    }

    public final ScxLoggerConfig setLevel(ScxLoggingLevel newLevel) {
        this.level = newLevel;
        return this;
    }

    public final ScxLoggerConfig setStackTrace(Boolean newStackTrace) {
        this.stackTrace = newStackTrace;
        return this;
    }

    public final ScxLoggerConfig addRecorder(ScxLogRecorder recorder, ScxLogRecorder ... recorders) {
        if (this.recorders == null) {
            this.recorders = new HashSet<ScxLogRecorder>();
        }
        this.recorders.add(recorder);
        this.recorders.addAll(List.of(recorders));
        return this;
    }

    public final ScxLoggerConfig removeRecorder(ScxLogRecorder recorder) {
        if (this.recorders != null) {
            this.recorders.remove(recorder);
        }
        return this;
    }

    public final ScxLoggerConfig clearRecorders() {
        this.recorders = null;
        return this;
    }
}

