/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.log4j;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggingLevel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public final class ScxLog4jLogger
extends AbstractLogger {
    private final ScxLogger scxLogger;

    public ScxLog4jLogger(String name) {
        super(name);
        this.scxLogger = ScxLoggerFactory.getLogger(name);
    }

    private static ScxLoggingLevel toScxLoggingLevel(Level level) {
        return switch (level.toString()) {
            case "OFF" -> ScxLoggingLevel.OFF;
            case "FATAL" -> ScxLoggingLevel.FATAL;
            case "ERROR" -> ScxLoggingLevel.ERROR;
            case "WARN" -> ScxLoggingLevel.WARN;
            case "INFO" -> ScxLoggingLevel.INFO;
            case "DEBUG" -> ScxLoggingLevel.DEBUG;
            case "TRACE" -> ScxLoggingLevel.TRACE;
            case "ALL" -> ScxLoggingLevel.ALL;
            default -> throw new IllegalArgumentException();
        };
    }

    private static Level toLog4jLevel(ScxLoggingLevel level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case ScxLoggingLevel.OFF -> Level.OFF;
            case ScxLoggingLevel.FATAL -> Level.FATAL;
            case ScxLoggingLevel.ERROR -> Level.ERROR;
            case ScxLoggingLevel.WARN -> Level.WARN;
            case ScxLoggingLevel.INFO -> Level.INFO;
            case ScxLoggingLevel.DEBUG -> Level.DEBUG;
            case ScxLoggingLevel.TRACE -> Level.TRACE;
            case ScxLoggingLevel.ALL -> Level.ALL;
        };
    }

    public boolean isEnabled(Level testLevel, Marker marker, Message msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, CharSequence msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, Object msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg, Object ... p1) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public void logMessage(String fqcn, Level mgsLevel, Marker marker, Message message, Throwable throwable) {
        this.scxLogger.logMessage(ScxLog4jLogger.toScxLoggingLevel(mgsLevel), message.getFormattedMessage(), throwable);
    }

    public Level getLevel() {
        return ScxLog4jLogger.toLog4jLevel(this.scxLogger.level());
    }
}

