/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.log4j;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerFactory;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.spi.AbstractLogger;

public final class ScxLog4jLogger
extends AbstractLogger {
    private final ScxLogger scxLogger;

    public ScxLog4jLogger(String name) {
        super(name);
        this.scxLogger = ScxLoggerFactory.getLogger(name);
    }

    private static System.Logger.Level toJDKLevel(Level level) {
        if (level == Level.OFF) {
            return System.Logger.Level.OFF;
        }
        if (level == Level.FATAL || level == Level.ERROR) {
            return System.Logger.Level.ERROR;
        }
        if (level == Level.WARN) {
            return System.Logger.Level.WARNING;
        }
        if (level == Level.INFO) {
            return System.Logger.Level.INFO;
        }
        if (level == Level.DEBUG) {
            return System.Logger.Level.DEBUG;
        }
        if (level == Level.TRACE) {
            return System.Logger.Level.TRACE;
        }
        if (level == Level.ALL) {
            return System.Logger.Level.ALL;
        }
        throw new IllegalArgumentException();
    }

    private static Level toLog4jLevel(System.Logger.Level level) {
        return switch (level) {
            default -> throw new IncompatibleClassChangeError();
            case System.Logger.Level.OFF -> Level.OFF;
            case System.Logger.Level.ERROR -> Level.ERROR;
            case System.Logger.Level.WARNING -> Level.WARN;
            case System.Logger.Level.INFO -> Level.INFO;
            case System.Logger.Level.DEBUG -> Level.DEBUG;
            case System.Logger.Level.TRACE -> Level.TRACE;
            case System.Logger.Level.ALL -> Level.ALL;
        };
    }

    public boolean isEnabled(Level testLevel, Marker marker, Message msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, CharSequence msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, Object msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg, Object ... p1) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public boolean isEnabled(Level testLevel, Marker marker, String msg, Throwable t) {
        return this.getLevel().intLevel() >= testLevel.intLevel();
    }

    public void logMessage(String fqcn, Level mgsLevel, Marker marker, Message message, Throwable throwable) {
        this.scxLogger.log(ScxLog4jLogger.toJDKLevel(mgsLevel), message.getFormattedMessage(), throwable);
    }

    public Level getLevel() {
        return ScxLog4jLogger.toLog4jLevel(this.scxLogger.level());
    }
}

