/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.ScxLoggerFactory;
import cool.scx.logging.ScxLoggerHelper;
import java.time.LocalDateTime;
import java.util.Set;

public class ScxLogger {
    private final String name;
    private final ScxLoggerConfig config;

    public ScxLogger(String name) {
        this.name = name;
        this.config = new ScxLoggerConfig(ScxLoggerFactory.defaultConfig());
    }

    public void log(System.Logger.Level level, String msg, Throwable throwable) {
        if (this.shouldSkip(level)) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        StackTraceElement[] contextStack = this.stackTrace() ? ScxLoggerHelper.getFilteredStackTrace(new Exception()) : null;
        ScxLogRecord logRecord = new ScxLogRecord(now, level, this.name, msg, Thread.currentThread().getName(), throwable, contextStack);
        Set<ScxLogRecorder> recorders = this.recorders();
        for (ScxLogRecorder r : recorders) {
            r.record(logRecord);
        }
    }

    protected boolean shouldSkip(System.Logger.Level level) {
        return level == System.Logger.Level.OFF;
    }

    public ScxLoggerConfig config() {
        return this.config;
    }

    public System.Logger.Level level() {
        return this.config.level();
    }

    public boolean stackTrace() {
        return this.config.stackTrace();
    }

    public Set<ScxLogRecorder> recorders() {
        return this.config.recorders();
    }

    public String name() {
        return this.name;
    }
}

