/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ScxLoggerConfig {
    private final ScxLoggerConfig parent;
    private System.Logger.Level level = null;
    private Boolean stackTrace = null;
    private Set<ScxLogRecorder> recorders = null;

    public ScxLoggerConfig(ScxLoggerConfig parent) {
        this.parent = parent;
    }

    public final System.Logger.Level level() {
        return this.level != null ? this.level : (this.parent != null ? this.parent.level() : System.Logger.Level.ERROR);
    }

    public final Boolean stackTrace() {
        return this.stackTrace != null ? this.stackTrace : (this.parent != null ? this.parent.stackTrace() : false);
    }

    public final Set<ScxLogRecorder> recorders() {
        return this.recorders != null ? this.recorders : (this.parent != null ? this.parent.recorders() : new HashSet());
    }

    public final ScxLoggerConfig setLevel(System.Logger.Level newLevel) {
        this.level = newLevel;
        return this;
    }

    public final ScxLoggerConfig setStackTrace(Boolean newStackTrace) {
        this.stackTrace = newStackTrace;
        return this;
    }

    public final ScxLoggerConfig addRecorder(ScxLogRecorder recorder, ScxLogRecorder ... recorders) {
        if (this.recorders == null) {
            this.recorders = new HashSet<ScxLogRecorder>();
        }
        this.recorders.add(recorder);
        Collections.addAll(this.recorders, recorders);
        return this;
    }

    public final ScxLoggerConfig removeRecorder(ScxLogRecorder recorder) {
        if (this.recorders != null) {
            this.recorders.remove(recorder);
        }
        return this;
    }

    public final ScxLoggerConfig clearRecorders() {
        this.recorders = null;
        return this;
    }
}

