/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.formatter;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.ScxLogRecordFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public final class DefaultFormatter
implements ScxLogRecordFormatter {
    public static final ScxLogRecordFormatter DEFAULT_INSTANCE = new DefaultFormatter();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");

    public static String formatTimeStamp(TemporalAccessor temporal) {
        return DATE_TIME_FORMATTER.format(temporal);
    }

    public static String formatStackTrace(StackTraceElement[] stackTraces) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : stackTraces) {
            sb.append("\t").append(traceElement).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public static String getFixedLengthLevelName(System.Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.ALL -> "ALL  ";
            case System.Logger.Level.TRACE -> "TRACE";
            case System.Logger.Level.DEBUG -> "DEBUG";
            case System.Logger.Level.INFO -> "INFO ";
            case System.Logger.Level.WARNING -> "WARN ";
            case System.Logger.Level.ERROR -> "ERROR";
            case System.Logger.Level.OFF -> "OFF  ";
        };
    }

    @Override
    public String format(ScxLogRecord event) {
        StringWriter sw = new StringWriter().append(DefaultFormatter.formatTimeStamp(event.timeStamp())).append(" [").append(event.threadName()).append("] ").append(DefaultFormatter.getFixedLengthLevelName(event.level())).append(" ").append(event.loggerName()).append(" - ").append(event.message()).append(System.lineSeparator());
        if (event.throwable() != null) {
            event.throwable().printStackTrace(new PrintWriter(sw));
        } else if (event.contextStack() != null) {
            sw.append(DefaultFormatter.formatStackTrace(event.contextStack()));
        }
        return sw.toString();
    }
}

