/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.slf4j;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;

public final class ScxSLF4JLogger
extends LegacyAbstractLogger {
    private final ScxLogger scxLogger;

    public ScxSLF4JLogger(String name) {
        this.name = name;
        this.scxLogger = ScxLoggerFactory.getLogger(name);
    }

    private static System.Logger.Level toJDKLevel(Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case Level.ERROR -> System.Logger.Level.ERROR;
            case Level.WARN -> System.Logger.Level.WARNING;
            case Level.INFO -> System.Logger.Level.INFO;
            case Level.DEBUG -> System.Logger.Level.DEBUG;
            case Level.TRACE -> System.Logger.Level.TRACE;
        };
    }

    private static Level toSLF4JLevel(System.Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.OFF, System.Logger.Level.ERROR -> Level.ERROR;
            case System.Logger.Level.WARNING -> Level.WARN;
            case System.Logger.Level.INFO -> Level.INFO;
            case System.Logger.Level.DEBUG -> Level.DEBUG;
            case System.Logger.Level.TRACE, System.Logger.Level.ALL -> Level.TRACE;
        };
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String message, Object[] arguments, Throwable throwable) {
        this.scxLogger.log(ScxSLF4JLogger.toJDKLevel(level), MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage(), throwable);
    }

    public boolean isTraceEnabled() {
        return this.getLevel().toInt() <= Level.TRACE.toInt();
    }

    public boolean isDebugEnabled() {
        return this.getLevel().toInt() <= Level.DEBUG.toInt();
    }

    public boolean isInfoEnabled() {
        return this.getLevel().toInt() <= Level.INFO.toInt();
    }

    public boolean isWarnEnabled() {
        return this.getLevel().toInt() <= Level.WARN.toInt();
    }

    public boolean isErrorEnabled() {
        return this.getLevel().toInt() <= Level.ERROR.toInt();
    }

    public Level getLevel() {
        return ScxSLF4JLogger.toSLF4JLevel(this.scxLogger.level());
    }
}

