/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.recorder;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.recorder.AbstractRecorder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public class FileRecorder
extends AbstractRecorder {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private final Path storedDirectory;

    public FileRecorder(Path storedDirectory) {
        this.storedDirectory = storedDirectory;
    }

    public String getLogFileName(TemporalAccessor temporal) {
        return DATE_TIME_FORMATTER.format(temporal) + ".log";
    }

    @Override
    public void record0(ScxLogRecord logRecord) {
        Path directory = this.storedDirectory;
        if (directory == null) {
            return;
        }
        String data = this.format(logRecord);
        String logFileName = this.getLogFileName(logRecord.timeStamp());
        Path path = directory.resolve(logFileName);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)data, StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

