/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.recorder;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.ScxLogRecorder;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;

public abstract class AbstractRecorder
implements ScxLogRecorder {
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    protected System.Logger.Level level = null;

    public System.Logger.Level level() {
        return this.level;
    }

    public AbstractRecorder setLevel(System.Logger.Level newLevel) {
        this.level = newLevel;
        return this;
    }

    public String formatTimeStamp(TemporalAccessor temporal) {
        return DATE_TIME_FORMATTER.format(temporal);
    }

    public String formatStackTrace(StackTraceElement[] stackTraces) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement traceElement : stackTraces) {
            sb.append("\t").append(traceElement).append(System.lineSeparator());
        }
        return sb.toString();
    }

    public String formatLevel(System.Logger.Level level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case System.Logger.Level.ALL -> "ALL  ";
            case System.Logger.Level.TRACE -> "TRACE";
            case System.Logger.Level.DEBUG -> "DEBUG";
            case System.Logger.Level.INFO -> "INFO ";
            case System.Logger.Level.WARNING -> "WARN ";
            case System.Logger.Level.ERROR -> "ERROR";
            case System.Logger.Level.OFF -> "OFF  ";
        };
    }

    public String format(ScxLogRecord event) {
        StringWriter sw = new StringWriter().append(this.formatTimeStamp(event.timeStamp())).append(" [").append(event.threadName()).append("] ").append(this.formatLevel(event.level())).append(" ").append(event.loggerName()).append(" - ").append(event.message()).append(System.lineSeparator());
        if (event.throwable() != null) {
            event.throwable().printStackTrace(new PrintWriter(sw));
        } else if (event.contextStack() != null) {
            sw.append(this.formatStackTrace(event.contextStack()));
        }
        return sw.toString();
    }

    @Override
    public final void record(ScxLogRecord logRecord) {
        if (this.isRecordable(logRecord)) {
            this.record0(logRecord);
        }
    }

    public boolean isRecordable(ScxLogRecord logRecord) {
        return this.level == null || this.level.getSeverity() <= logRecord.level().getSeverity();
    }

    public abstract void record0(ScxLogRecord var1);
}

