/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging.spi.slf4j;

import cool.scx.logging.ScxLogger;
import cool.scx.logging.spi.slf4j.ScxSLF4JLoggerHelper;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.LegacyAbstractLogger;
import org.slf4j.helpers.MessageFormatter;

public final class ScxSLF4JLogger
extends LegacyAbstractLogger {
    private final ScxLogger scxLogger;

    public ScxSLF4JLogger(ScxLogger scxLogger) {
        this.name = scxLogger.name();
        this.scxLogger = scxLogger;
    }

    private boolean isLoggable(Level level) {
        return this.scxLogger.isLoggable(ScxSLF4JLoggerHelper.toJDKLevel(level));
    }

    public boolean isTraceEnabled() {
        return this.isLoggable(Level.TRACE);
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isLoggable(Level.INFO);
    }

    public boolean isWarnEnabled() {
        return this.isLoggable(Level.WARN);
    }

    public boolean isErrorEnabled() {
        return this.isLoggable(Level.ERROR);
    }

    protected String getFullyQualifiedCallerName() {
        return null;
    }

    protected void handleNormalizedLoggingCall(Level level, Marker marker, String msg, Object[] args, Throwable t) {
        this.scxLogger.log0(ScxSLF4JLoggerHelper.toJDKLevel(level), MessageFormatter.basicArrayFormat((String)msg, (Object[])args), t);
    }
}

