/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecord;
import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.ScxLoggerHelper;
import java.time.LocalDateTime;
import java.util.Set;

public record ScxLogger(String name, ScxLoggerConfig config) {
    public boolean isLoggable(System.Logger.Level level) {
        return level.getSeverity() >= this.config.level().getSeverity();
    }

    public void log(System.Logger.Level level, String message, Throwable t) {
        if (this.isLoggable(level)) {
            this.log0(level, message, t);
        }
    }

    public void log0(System.Logger.Level level, String message, Throwable t) {
        LocalDateTime now = LocalDateTime.now();
        Thread thread = Thread.currentThread();
        StackTraceElement[] contextStack = this.config.stackTrace() != false ? ScxLoggerHelper.getFilteredStackTrace(new Exception()) : null;
        ScxLogRecord logRecord = new ScxLogRecord(now, level, this.name, message, thread.getName(), t, contextStack);
        Set<ScxLogRecorder> recorders = this.config.recorders();
        for (ScxLogRecorder r : recorders) {
            r.record(logRecord);
        }
    }
}

