/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.recorder.ConsoleRecorder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public final class ScxLoggerFactory {
    static final System.Logger.Level DEFAULT_LEVEL = System.Logger.Level.ERROR;
    static final Boolean DEFAULT_STACK_TRACE = false;
    static final Set<ScxLogRecorder> DEFAULT_RECORDERS = Set.of(new ConsoleRecorder());
    private static final Map<String, ScxLogger> LOGGERS = new ConcurrentHashMap<String, ScxLogger>();
    private static final Map<String, ScxLoggerConfig> CONFIGS = Collections.synchronizedMap(new LinkedHashMap());
    private static final ScxLoggerConfig ROOT_CONFIG = new ScxLoggerConfig();

    public static ScxLoggerConfig rootConfig() {
        return ROOT_CONFIG;
    }

    private static ScxLoggerConfig findConfig(String name) {
        ArrayList<Map.Entry<String, ScxLoggerConfig>> list = new ArrayList<Map.Entry<String, ScxLoggerConfig>>(CONFIGS.entrySet());
        for (Map.Entry entry : list.reversed()) {
            boolean b = Pattern.matches((String)entry.getKey(), name);
            if (!b) continue;
            return (ScxLoggerConfig)entry.getValue();
        }
        return null;
    }

    private static ScxLogger createLogger(String name) {
        ScxLogger scxLogger = new ScxLogger(name, new ScxLoggerConfig(ROOT_CONFIG));
        ScxLoggerConfig config = ScxLoggerFactory.findConfig(name);
        if (config != null) {
            scxLogger.config().updateConfig(config);
        }
        return scxLogger;
    }

    public static ScxLogger getLogger(String name) {
        return LOGGERS.computeIfAbsent(name, ScxLoggerFactory::createLogger);
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    public static void setConfig(String name, ScxLoggerConfig newConfig) {
        for (ScxLogger value : LOGGERS.values()) {
            boolean b = Pattern.matches(name, value.name());
            if (!b) continue;
            value.config().updateConfig(newConfig);
        }
        CONFIGS.put(name, newConfig);
    }

    public static void removeConfig(String name) {
        CONFIGS.remove(name);
    }
}

