/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import cool.scx.logging.ScxLogger;
import cool.scx.logging.ScxLoggerConfig;
import cool.scx.logging.recorder.ConsoleRecorder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;

public final class ScxLoggerFactory {
    static final System.Logger.Level DEFAULT_LEVEL = System.Logger.Level.ERROR;
    static final Boolean DEFAULT_STACK_TRACE = false;
    static final Set<ScxLogRecorder> DEFAULT_RECORDERS = Set.of(new ConsoleRecorder());
    private static final ScxLoggerConfig ROOT_CONFIG = new ScxLoggerConfig();
    private static final ConcurrentHashMap<String, ScxLogger> LOGGERS = new ConcurrentHashMap();
    private static final LinkedHashMap<String, ScxLoggerConfig> CONFIGS = new LinkedHashMap();
    private static final ReentrantReadWriteLock CONFIGS_LOCK = new ReentrantReadWriteLock();

    public static ScxLoggerConfig rootConfig() {
        return ROOT_CONFIG;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ScxLoggerConfig findConfig(String name) {
        CONFIGS_LOCK.readLock().lock();
        try {
            for (Map.Entry<String, ScxLoggerConfig> entry : CONFIGS.entrySet()) {
                boolean b = Pattern.matches(entry.getKey(), name);
                if (!b) continue;
                ScxLoggerConfig scxLoggerConfig = entry.getValue();
                return scxLoggerConfig;
            }
            Iterator<Map.Entry<String, ScxLoggerConfig>> iterator = null;
            return iterator;
        }
        finally {
            CONFIGS_LOCK.readLock().unlock();
        }
    }

    private static ScxLogger createLogger(String name) {
        ScxLogger scxLogger = new ScxLogger(name, new ScxLoggerConfig(ROOT_CONFIG));
        ScxLoggerConfig config = ScxLoggerFactory.findConfig(name);
        if (config != null) {
            scxLogger.config().updateConfig(config);
        }
        return scxLogger;
    }

    public static ScxLogger getLogger(String name) {
        return LOGGERS.computeIfAbsent(name, ScxLoggerFactory::createLogger);
    }

    public static ScxLogger getLogger(Class<?> clazz) {
        return ScxLoggerFactory.getLogger(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfig(String name, ScxLoggerConfig newConfig) {
        CONFIGS_LOCK.writeLock().lock();
        try {
            CONFIGS.putFirst(name, newConfig);
            for (ScxLogger value : LOGGERS.values()) {
                boolean b = Pattern.matches(name, value.name());
                if (!b) continue;
                value.config().updateConfig(newConfig);
            }
        }
        finally {
            CONFIGS_LOCK.writeLock().unlock();
        }
    }

    public static void removeConfig(String name) {
        CONFIGS_LOCK.writeLock().lock();
        try {
            CONFIGS.remove(name);
        }
        finally {
            CONFIGS_LOCK.writeLock().unlock();
        }
    }
}

