/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.logging;

import cool.scx.logging.ScxLogRecorder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ScxLoggerConfig {
    private final ScxLoggerConfig parent;
    private System.Logger.Level level = null;
    private Boolean stackTrace = null;
    private Set<ScxLogRecorder> recorders = null;

    public ScxLoggerConfig(ScxLoggerConfig parent) {
        this.parent = parent;
    }

    public ScxLoggerConfig() {
        this.parent = null;
    }

    public System.Logger.Level level() {
        if (this.level != null) {
            return this.level;
        }
        if (this.parent != null) {
            return this.parent.level();
        }
        throw new IllegalStateException("level is not configured and no fallback found");
    }

    public Boolean stackTrace() {
        if (this.stackTrace != null) {
            return this.stackTrace;
        }
        if (this.parent != null) {
            return this.parent.stackTrace();
        }
        throw new IllegalStateException("stackTrace is not configured and no fallback found");
    }

    public Set<ScxLogRecorder> recorders() {
        if (this.recorders != null) {
            return this.recorders;
        }
        if (this.parent != null) {
            return this.parent.recorders();
        }
        throw new IllegalStateException("recorders is not configured and no fallback found");
    }

    public ScxLoggerConfig setLevel(System.Logger.Level newLevel) {
        this.level = newLevel;
        return this;
    }

    public ScxLoggerConfig setStackTrace(Boolean newStackTrace) {
        this.stackTrace = newStackTrace;
        return this;
    }

    public ScxLoggerConfig setRecorder(Set<ScxLogRecorder> recorders) {
        this.recorders = recorders != null ? new HashSet<ScxLogRecorder>(recorders) : null;
        return this;
    }

    public ScxLoggerConfig clearLevel() {
        this.level = null;
        return this;
    }

    public ScxLoggerConfig clearStackTrace() {
        this.stackTrace = null;
        return this;
    }

    public ScxLoggerConfig clearRecorders() {
        this.recorders = null;
        return this;
    }

    public ScxLoggerConfig addRecorder(ScxLogRecorder ... recorders) {
        if (this.recorders == null) {
            this.recorders = new HashSet<ScxLogRecorder>();
        }
        Collections.addAll(this.recorders, recorders);
        return this;
    }

    public ScxLoggerConfig removeRecorder(ScxLogRecorder recorder) {
        if (this.recorders != null) {
            this.recorders.remove(recorder);
        }
        return this;
    }

    public ScxLoggerConfig updateConfig(ScxLoggerConfig newConfig) {
        this.setLevel(newConfig.level);
        this.setStackTrace(newConfig.stackTrace);
        this.setRecorder(newConfig.recorders);
        return this;
    }
}

